/*
 * Decompiled with CFR 0.152.
 */
package pl.charmas.android.reactivelocation.observables.geocode;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import pl.charmas.android.reactivelocation.observables.geocode.FallbackReverseGeocodeObservable;
import rx.Observable;
import rx.Subscriber;
import rx.schedulers.Schedulers;

public class ReverseGeocodeObservable
implements Observable.OnSubscribe<List<Address>> {
    private final Context ctx;
    private final Locale locale;
    private final double latitude;
    private final double longitude;
    private final int maxResults;

    public static Observable<List<Address>> createObservable(Context ctx, Locale locale, double latitude, double longitude, int maxResults) {
        return Observable.create((Observable.OnSubscribe)new ReverseGeocodeObservable(ctx, locale, latitude, longitude, maxResults));
    }

    private ReverseGeocodeObservable(Context ctx, Locale locale, double latitude, double longitude, int maxResults) {
        this.ctx = ctx;
        this.latitude = latitude;
        this.longitude = longitude;
        this.maxResults = maxResults;
        this.locale = locale;
    }

    public void call(Subscriber<? super List<Address>> subscriber) {
        Geocoder geocoder = new Geocoder(this.ctx, this.locale);
        try {
            subscriber.onNext((Object)geocoder.getFromLocation(this.latitude, this.longitude, this.maxResults));
            subscriber.onCompleted();
        }
        catch (IOException e) {
            if (e.getMessage().equalsIgnoreCase("Service not Available")) {
                Observable.create((Observable.OnSubscribe)new FallbackReverseGeocodeObservable(this.locale, this.latitude, this.longitude, this.maxResults)).subscribeOn(Schedulers.io()).subscribe(subscriber);
            }
            subscriber.onError((Throwable)e);
        }
    }
}

