/*
 * Decompiled with CFR 0.152.
 */
package pl.charmas.android.reactivelocation.observables;

import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class PendingResultObservable<T extends Result>
implements Observable.OnSubscribe<T> {
    private final PendingResult<T> result;
    private boolean complete = false;

    public PendingResultObservable(PendingResult<T> result) {
        this.result = result;
    }

    public void call(final Subscriber<? super T> subscriber) {
        this.result.setResultCallback(new ResultCallback<T>(){

            public void onResult(T t) {
                subscriber.onNext(t);
                PendingResultObservable.this.complete = true;
                subscriber.onCompleted();
            }
        });
        subscriber.add(Subscriptions.create((Action0)new Action0(){

            public void call() {
                if (!PendingResultObservable.this.complete) {
                    PendingResultObservable.this.result.cancel();
                }
            }
        }));
    }
}

