/*
 * Decompiled with CFR 0.152.
 */
package pl.charmas.android.reactivelocation.observables;

import android.content.Context;
import android.os.Bundle;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import java.util.Arrays;
import java.util.List;
import pl.charmas.android.reactivelocation.observables.GoogleAPIConnectionException;
import pl.charmas.android.reactivelocation.observables.GoogleAPIConnectionSuspendedException;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public abstract class BaseObservable<T>
implements Observable.OnSubscribe<T> {
    private final Context ctx;
    private final List<Api<? extends Api.ApiOptions.NotRequiredOptions>> services;

    @SafeVarargs
    protected BaseObservable(Context ctx, Api<? extends Api.ApiOptions.NotRequiredOptions> ... services) {
        this.ctx = ctx;
        this.services = Arrays.asList(services);
    }

    public void call(Subscriber<? super T> subscriber) {
        final GoogleApiClient apiClient = this.createApiClient(subscriber);
        try {
            apiClient.connect();
        }
        catch (Throwable ex) {
            subscriber.onError(ex);
        }
        subscriber.add(Subscriptions.create((Action0)new Action0(){

            public void call() {
                if (apiClient.isConnected() || apiClient.isConnecting()) {
                    BaseObservable.this.onUnsubscribed(apiClient);
                    apiClient.disconnect();
                }
            }
        }));
    }

    protected GoogleApiClient createApiClient(Subscriber<? super T> subscriber) {
        ApiClientConnectionCallbacks apiClientConnectionCallbacks = new ApiClientConnectionCallbacks((Observer)subscriber);
        GoogleApiClient.Builder apiClientBuilder = new GoogleApiClient.Builder(this.ctx);
        for (Api<? extends Api.ApiOptions.NotRequiredOptions> service : this.services) {
            apiClientBuilder.addApi(service);
        }
        apiClientBuilder.addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)apiClientConnectionCallbacks);
        apiClientBuilder.addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)apiClientConnectionCallbacks);
        GoogleApiClient apiClient = apiClientBuilder.build();
        apiClientConnectionCallbacks.setClient(apiClient);
        return apiClient;
    }

    protected void onUnsubscribed(GoogleApiClient locationClient) {
    }

    protected abstract void onGoogleApiClientReady(GoogleApiClient var1, Observer<? super T> var2);

    private class ApiClientConnectionCallbacks
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private final Observer<? super T> observer;
        private GoogleApiClient apiClient;

        private ApiClientConnectionCallbacks(Observer<? super T> observer) {
            this.observer = observer;
        }

        public void onConnected(Bundle bundle) {
            try {
                BaseObservable.this.onGoogleApiClientReady(this.apiClient, this.observer);
            }
            catch (Throwable ex) {
                this.observer.onError(ex);
            }
        }

        public void onConnectionSuspended(int cause) {
            this.observer.onError((Throwable)new GoogleAPIConnectionSuspendedException(cause));
        }

        public void onConnectionFailed(ConnectionResult connectionResult) {
            this.observer.onError((Throwable)new GoogleAPIConnectionException("Error connecting to GoogleApiClient.", connectionResult));
        }

        public void setClient(GoogleApiClient client) {
            this.apiClient = client;
        }
    }
}

