/*
 * Decompiled with CFR 0.152.
 */
package pl.charmas.android.reactivelocation;

import android.app.PendingIntent;
import android.content.Context;
import android.location.Address;
import android.location.Location;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.ActivityRecognitionResult;
import com.google.android.gms.location.GeofencingRequest;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.AutocompletePredictionBuffer;
import com.google.android.gms.location.places.PlaceBuffer;
import com.google.android.gms.location.places.PlaceFilter;
import com.google.android.gms.location.places.PlaceLikelihoodBuffer;
import com.google.android.gms.location.places.Places;
import com.google.android.gms.maps.model.LatLngBounds;
import java.util.List;
import java.util.Locale;
import pl.charmas.android.reactivelocation.observables.GoogleAPIClientObservable;
import pl.charmas.android.reactivelocation.observables.PendingResultObservable;
import pl.charmas.android.reactivelocation.observables.activity.ActivityUpdatesObservable;
import pl.charmas.android.reactivelocation.observables.geocode.GeocodeObservable;
import pl.charmas.android.reactivelocation.observables.geocode.ReverseGeocodeObservable;
import pl.charmas.android.reactivelocation.observables.geofence.AddGeofenceObservable;
import pl.charmas.android.reactivelocation.observables.geofence.RemoveGeofenceObservable;
import pl.charmas.android.reactivelocation.observables.location.AddLocationIntentUpdatesObservable;
import pl.charmas.android.reactivelocation.observables.location.LastKnownLocationObservable;
import pl.charmas.android.reactivelocation.observables.location.LocationUpdatesObservable;
import pl.charmas.android.reactivelocation.observables.location.MockLocationObservable;
import pl.charmas.android.reactivelocation.observables.location.RemoveLocationIntentUpdatesObservable;
import rx.Observable;
import rx.functions.Func1;

public class ReactiveLocationProvider {
    private final Context ctx;

    public ReactiveLocationProvider(Context ctx) {
        this.ctx = ctx;
    }

    public Observable<Location> getLastKnownLocation() {
        return LastKnownLocationObservable.createObservable(this.ctx);
    }

    public Observable<Location> getUpdatedLocation(LocationRequest locationRequest) {
        return LocationUpdatesObservable.createObservable(this.ctx, locationRequest);
    }

    public Observable<Status> mockLocation(Observable<Location> sourceLocationObservable) {
        return MockLocationObservable.createObservable(this.ctx, sourceLocationObservable);
    }

    public Observable<Status> requestLocationUpdates(LocationRequest locationRequest, PendingIntent intent) {
        return AddLocationIntentUpdatesObservable.createObservable(this.ctx, locationRequest, intent);
    }

    public Observable<Status> removeLocationUpdates(PendingIntent intent) {
        return RemoveLocationIntentUpdatesObservable.createObservable(this.ctx, intent);
    }

    public Observable<List<Address>> getReverseGeocodeObservable(double lat, double lng, int maxResults) {
        return ReverseGeocodeObservable.createObservable(this.ctx, Locale.getDefault(), lat, lng, maxResults);
    }

    public Observable<List<Address>> getReverseGeocodeObservable(Locale locale, double lat, double lng, int maxResults) {
        return ReverseGeocodeObservable.createObservable(this.ctx, locale, lat, lng, maxResults);
    }

    public Observable<List<Address>> getGeocodeObservable(String locationName, int maxResults) {
        return this.getGeocodeObservable(locationName, maxResults, null);
    }

    public Observable<List<Address>> getGeocodeObservable(String locationName, int maxResults, LatLngBounds bounds) {
        return GeocodeObservable.createObservable(this.ctx, locationName, maxResults, bounds);
    }

    public Observable<Status> addGeofences(PendingIntent geofenceTransitionPendingIntent, GeofencingRequest request) {
        return AddGeofenceObservable.createObservable(this.ctx, request, geofenceTransitionPendingIntent);
    }

    public Observable<Status> removeGeofences(PendingIntent pendingIntent) {
        return RemoveGeofenceObservable.createObservable(this.ctx, pendingIntent);
    }

    public Observable<Status> removeGeofences(List<String> requestIds) {
        return RemoveGeofenceObservable.createObservable(this.ctx, requestIds);
    }

    public Observable<ActivityRecognitionResult> getDetectedActivity(int detectIntervalMiliseconds) {
        return ActivityUpdatesObservable.createObservable(this.ctx, detectIntervalMiliseconds);
    }

    public Observable<LocationSettingsResult> checkLocationSettings(final LocationSettingsRequest locationRequest) {
        return this.getGoogleApiClientObservable(LocationServices.API).flatMap((Func1)new Func1<GoogleApiClient, Observable<LocationSettingsResult>>(){

            public Observable<LocationSettingsResult> call(GoogleApiClient googleApiClient) {
                return ReactiveLocationProvider.fromPendingResult(LocationServices.SettingsApi.checkLocationSettings(googleApiClient, locationRequest));
            }
        });
    }

    public Observable<PlaceLikelihoodBuffer> getCurrentPlace(final @Nullable PlaceFilter placeFilter) {
        return this.getGoogleApiClientObservable(Places.PLACE_DETECTION_API, Places.GEO_DATA_API).flatMap((Func1)new Func1<GoogleApiClient, Observable<PlaceLikelihoodBuffer>>(){

            public Observable<PlaceLikelihoodBuffer> call(GoogleApiClient api) {
                return ReactiveLocationProvider.fromPendingResult(Places.PlaceDetectionApi.getCurrentPlace(api, placeFilter));
            }
        });
    }

    public Observable<PlaceBuffer> getPlaceById(final @Nullable String placeId) {
        return this.getGoogleApiClientObservable(Places.PLACE_DETECTION_API, Places.GEO_DATA_API).flatMap((Func1)new Func1<GoogleApiClient, Observable<PlaceBuffer>>(){

            public Observable<PlaceBuffer> call(GoogleApiClient api) {
                return ReactiveLocationProvider.fromPendingResult(Places.GeoDataApi.getPlaceById(api, new String[]{placeId}));
            }
        });
    }

    public Observable<AutocompletePredictionBuffer> getPlaceAutocompletePredictions(final String query, final LatLngBounds bounds, final AutocompleteFilter filter) {
        return this.getGoogleApiClientObservable(Places.PLACE_DETECTION_API, Places.GEO_DATA_API).flatMap((Func1)new Func1<GoogleApiClient, Observable<AutocompletePredictionBuffer>>(){

            public Observable<AutocompletePredictionBuffer> call(GoogleApiClient api) {
                return ReactiveLocationProvider.fromPendingResult(Places.GeoDataApi.getAutocompletePredictions(api, query, bounds, filter));
            }
        });
    }

    public Observable<GoogleApiClient> getGoogleApiClientObservable(Api ... apis) {
        return GoogleAPIClientObservable.create(this.ctx, apis);
    }

    public static <T extends Result> Observable<T> fromPendingResult(PendingResult<T> result) {
        return Observable.create(new PendingResultObservable<T>(result));
    }
}

