/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.LetExpression;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class NodeUtils {
    public static final ObjectMapper mapper = new ObjectMapper();

    public static Scope evalLets(Scope scope, JsonNode input, LetExpression[] lets) {
        for (int ix = 0; ix < lets.length; ++ix) {
            String var = lets[ix].getVariable();
            JsonNode val = lets[ix].apply(scope, input);
            scope = Scope.makeScope(Collections.singletonMap(var, val), scope);
        }
        return scope;
    }

    public static boolean isTrue(JsonNode value) {
        return !(value == BooleanNode.FALSE || value.isObject() && value.size() == 0 || value.isTextual() && value.asText().length() == 0 || value.isArray() && value.size() == 0 || value.isNumber() && value.doubleValue() == 0.0 || value.isNull());
    }

    public static boolean isValue(JsonNode value) {
        return !(value.isNull() || value.isObject() && value.size() == 0 || value.isArray() && value.size() == 0);
    }

    public static JsonNode toJson(boolean value) {
        if (value) {
            return BooleanNode.TRUE;
        }
        return BooleanNode.FALSE;
    }

    public static JsonNode toJson(double value) {
        return new DoubleNode(value);
    }

    public static JsonNode toJson(String[] array) {
        ArrayNode node = mapper.createArrayNode();
        for (int ix = 0; ix < array.length; ++ix) {
            node.add(array[ix]);
        }
        return node;
    }

    public static String toString(JsonNode value, boolean nullok) {
        if (value.isTextual()) {
            return value.asText();
        }
        if (value.isNull() && nullok) {
            return null;
        }
        return value.toString();
    }

    public static ArrayNode toArray(JsonNode value, boolean nullok) {
        if (value.isArray()) {
            return (ArrayNode)value;
        }
        if (value.isNull() && nullok) {
            return null;
        }
        throw new JsltException("Cannot convert " + value + " to array");
    }

    public static JsonNode number(JsonNode value, Location loc) {
        return NodeUtils.number(value, false, loc);
    }

    public static JsonNode number(JsonNode value, boolean strict, Location loc) {
        return NodeUtils.number(value, strict, loc, null);
    }

    public static JsonNode number(JsonNode value, boolean strict, Location loc, JsonNode fallback) {
        if (value.isNumber() || value.isNull()) {
            return value;
        }
        if (!value.isTextual()) {
            if (strict) {
                throw new JsltException("Can't convert " + value + " to number", loc);
            }
            if (fallback == null) {
                return NullNode.instance;
            }
            return fallback;
        }
        String number = value.asText();
        try {
            if (number.indexOf(46) != -1) {
                return new DoubleNode(Double.parseDouble(number));
            }
            return new IntNode(Integer.parseInt(number));
        }
        catch (NumberFormatException e) {
            if (fallback == null) {
                throw new JsltException("number(" + number + ") failed: not a number", loc);
            }
            return fallback;
        }
    }

    public static ArrayNode convertObjectToArray(JsonNode object) {
        ArrayNode array = mapper.createArrayNode();
        Iterator it = object.fields();
        while (it.hasNext()) {
            Map.Entry item = (Map.Entry)it.next();
            ObjectNode element = mapper.createObjectNode();
            element.set("key", (JsonNode)new TextNode((String)item.getKey()));
            element.set("value", (JsonNode)item.getValue());
            array.add((JsonNode)element);
        }
        return array;
    }

    public static String indent(int level) {
        char[] indent = new char[level * 2];
        for (int ix = 0; ix < indent.length; ++ix) {
            indent[ix] = 32;
        }
        return new String(indent, 0, indent.length);
    }
}

