package com.scansolutions.mrzscannerlib;

import android.content.Context;
import android.util.Log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class TesseractHelper {

    private static final String TAG = "TESSERACT_HELPER";

    private static final String TESSDATA = "tessdata";
    private static String DATA_PATH;

    static void prepareTesseract(Context context) {
        DATA_PATH = context.getFilesDir().getAbsolutePath() + "/TesseractFiles/";
        try {
            prepareDirectory(DATA_PATH + TESSDATA);
        } catch (Exception e) {
            e.printStackTrace();
        }

        copyTessDataFiles(context);
    }

    private static void prepareDirectory(String path) {
        File dir = new File(path);
        dir.setReadable(true);
        dir.setWritable(true);

        if (!dir.mkdirs()) {
//            Log.e(TAG, "ERROR: Creation of directory " + path + " failed, check does Android Manifest have permission to write to external storage.");
        }
    }

    private static void copyTessDataFiles(Context context) {
        try {
            String[] fileList = context.getAssets().list(TESSDATA);

            if (fileList != null) {
                for (String fileName : fileList) {
                    String pathToDataFile = DATA_PATH + TESSDATA + "/" + fileName;
                    InputStream in = context.getAssets().open(TESSDATA + "/" + fileName);

                    OutputStream out = new FileOutputStream(pathToDataFile, false);

                    byte[] buf = new byte[1024];
                    int len;

                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }

                    in.close();
                    out.close();
                }
            }
        } catch (IOException e) {
            Log.e(TAG, "Unable to copy files to tessdata " + e.toString());
        }
    }

    static String getDataPath() {
        return DATA_PATH + TESSDATA;
    }
}
