/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.scansolutions.mrzscannerlib.MRZScanner;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class MRZResultModel
implements Parcelable {
    public static final Parcelable.Creator CREATOR;
    public String rawResult;
    public String documentTypeRaw;
    public String documentTypeReadable;
    public String issuingCountry;
    public String[] surnames;
    public String[] givenNames;
    public String documentNumber;
    public String documentNumberWithCheckDigit;
    public String nationality;
    public String dobRaw;
    public String dobWithCheckDigit;
    public String dobReadable;
    public String sex;
    public String expirationDateRaw;
    public String expirationDateWithCheckDigit;
    public String expirationDateReadable;
    public String estIssuingDateRaw;
    public String estIssuingDateReadable;
    public String masterCheckDigit;
    public boolean areCheckDigitsValid;
    public String[] optionals;
    public long dateScanned;
    public Bitmap portrait;
    public Bitmap signature;
    public Bitmap fullImage;
    public Bitmap idBack;
    public Bitmap idFront;

    public MRZResultModel() {
        this.rawResult = "N/A";
        this.documentTypeRaw = "N/A";
        this.documentTypeReadable = "N/A";
        this.issuingCountry = "N/A";
        this.documentNumber = "N/A";
        this.documentNumberWithCheckDigit = "N/A";
        this.nationality = "N/A";
        this.dobRaw = "N/A";
        this.dobWithCheckDigit = "N/A";
        this.dobReadable = "N/A";
        this.sex = "N/A";
        this.expirationDateRaw = "N/A";
        this.expirationDateWithCheckDigit = "N/A";
        this.expirationDateReadable = "N/A";
        this.estIssuingDateRaw = "N/A";
        this.estIssuingDateReadable = "N/A";
        this.masterCheckDigit = "N/A";
    }

    public MRZResultModel(Parcel parcel) {
        this.rawResult = "N/A";
        this.documentTypeRaw = "N/A";
        this.documentTypeReadable = "N/A";
        this.issuingCountry = "N/A";
        this.documentNumber = "N/A";
        this.documentNumberWithCheckDigit = "N/A";
        this.nationality = "N/A";
        this.dobRaw = "N/A";
        this.dobWithCheckDigit = "N/A";
        this.dobReadable = "N/A";
        this.sex = "N/A";
        this.expirationDateRaw = "N/A";
        this.expirationDateWithCheckDigit = "N/A";
        this.expirationDateReadable = "N/A";
        this.estIssuingDateRaw = "N/A";
        this.estIssuingDateReadable = "N/A";
        this.masterCheckDigit = "N/A";
        this.rawResult = parcel.readString();
        this.documentTypeRaw = parcel.readString();
        this.issuingCountry = parcel.readString();
        this.surnames = parcel.createStringArray();
        this.givenNames = parcel.createStringArray();
        this.documentNumber = parcel.readString();
        this.documentNumberWithCheckDigit = parcel.readString();
        this.nationality = parcel.readString();
        this.dobRaw = parcel.readString();
        this.dobWithCheckDigit = parcel.readString();
        this.sex = parcel.readString();
        this.estIssuingDateRaw = parcel.readString();
        this.expirationDateRaw = parcel.readString();
        this.expirationDateWithCheckDigit = parcel.readString();
        this.masterCheckDigit = parcel.readString();
        boolean bl = parcel.readInt() > 0;
        this.areCheckDigitsValid = bl;
        this.optionals = parcel.createStringArray();
        this.dateScanned = parcel.readLong();
        this.portrait = (Bitmap)parcel.readParcelable(Bitmap.class.getClassLoader());
        this.signature = (Bitmap)parcel.readParcelable(Bitmap.class.getClassLoader());
        this.fullImage = (Bitmap)parcel.readParcelable(Bitmap.class.getClassLoader());
        this.idBack = (Bitmap)parcel.readParcelable(Bitmap.class.getClassLoader());
        this.idFront = (Bitmap)parcel.readParcelable(Bitmap.class.getClassLoader());
        this.parseRawToReadable();
    }

    public MRZResultModel(String string, String string2, String[] stringArray, String[] stringArray2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String[] stringArray3, long l2, Bitmap bitmap, Bitmap bitmap2, Bitmap bitmap3, Bitmap bitmap4, Bitmap bitmap5, boolean bl) {
        MRZResultModel mRZResultModel = this;
        mRZResultModel.rawResult = "N/A";
        mRZResultModel.documentTypeRaw = "N/A";
        mRZResultModel.documentTypeReadable = "N/A";
        mRZResultModel.issuingCountry = "N/A";
        mRZResultModel.documentNumber = "N/A";
        mRZResultModel.documentNumberWithCheckDigit = "N/A";
        mRZResultModel.nationality = "N/A";
        mRZResultModel.dobRaw = "N/A";
        mRZResultModel.dobWithCheckDigit = "N/A";
        mRZResultModel.dobReadable = "N/A";
        mRZResultModel.sex = "N/A";
        mRZResultModel.expirationDateRaw = "N/A";
        mRZResultModel.expirationDateWithCheckDigit = "N/A";
        mRZResultModel.expirationDateReadable = "N/A";
        mRZResultModel.estIssuingDateRaw = "N/A";
        mRZResultModel.estIssuingDateReadable = "N/A";
        mRZResultModel.masterCheckDigit = "N/A";
        mRZResultModel.documentTypeRaw = string;
        mRZResultModel.issuingCountry = string2;
        mRZResultModel.surnames = stringArray;
        mRZResultModel.givenNames = stringArray2;
        mRZResultModel.documentNumber = string3;
        mRZResultModel.documentNumberWithCheckDigit = string4;
        mRZResultModel.nationality = string5;
        mRZResultModel.dobRaw = string6;
        mRZResultModel.dobWithCheckDigit = string7;
        mRZResultModel.sex = string8;
        mRZResultModel.expirationDateRaw = string10;
        mRZResultModel.estIssuingDateRaw = string9;
        mRZResultModel.expirationDateWithCheckDigit = string11;
        mRZResultModel.masterCheckDigit = string12;
        mRZResultModel.optionals = stringArray3;
        mRZResultModel.dateScanned = l2;
        mRZResultModel.portrait = bitmap;
        mRZResultModel.signature = bitmap2;
        mRZResultModel.fullImage = bitmap3;
        mRZResultModel.idBack = bitmap4;
        mRZResultModel.idFront = bitmap5;
        mRZResultModel.areCheckDigitsValid = bl;
        mRZResultModel.parseRawToReadable();
    }

    MRZResultModel(JSONObject object, long l2) {
        int n2;
        ((MRZResultModel)((Object)string)).rawResult = "N/A";
        ((MRZResultModel)((Object)string)).documentTypeRaw = "N/A";
        ((MRZResultModel)((Object)string)).documentTypeReadable = "N/A";
        ((MRZResultModel)((Object)string)).issuingCountry = "N/A";
        ((MRZResultModel)((Object)string)).documentNumber = "N/A";
        ((MRZResultModel)((Object)string)).documentNumberWithCheckDigit = "N/A";
        ((MRZResultModel)((Object)string)).nationality = "N/A";
        ((MRZResultModel)((Object)string)).dobRaw = "N/A";
        ((MRZResultModel)((Object)string)).dobWithCheckDigit = "N/A";
        ((MRZResultModel)((Object)string)).dobReadable = "N/A";
        ((MRZResultModel)((Object)string)).sex = "N/A";
        ((MRZResultModel)((Object)string)).expirationDateRaw = "N/A";
        ((MRZResultModel)((Object)string)).expirationDateWithCheckDigit = "N/A";
        ((MRZResultModel)((Object)string)).expirationDateReadable = "N/A";
        ((MRZResultModel)((Object)string)).estIssuingDateRaw = "N/A";
        ((MRZResultModel)((Object)string)).estIssuingDateReadable = "N/A";
        ((MRZResultModel)((Object)string)).masterCheckDigit = "N/A";
        ((MRZResultModel)((Object)string)).dateScanned = l2;
        ((MRZResultModel)((Object)string)).rawResult = object.getString("raw_result");
        ((MRZResultModel)((Object)string)).documentTypeRaw = object.getString("document_type_raw");
        ((MRZResultModel)((Object)string)).documentTypeReadable = object.getString("document_type_readable");
        ((MRZResultModel)((Object)string)).issuingCountry = object.getString("issuing_country");
        ((MRZResultModel)((Object)string)).documentNumber = object.getString("document_number");
        ((MRZResultModel)((Object)string)).documentNumberWithCheckDigit = object.getString("document_number_with_check_digit");
        ((MRZResultModel)((Object)string)).nationality = object.getString("nationality");
        ((MRZResultModel)((Object)string)).dobRaw = object.getString("dob_raw");
        ((MRZResultModel)((Object)string)).dobReadable = object.getString("dob_readable");
        ((MRZResultModel)((Object)string)).dobWithCheckDigit = object.getString("dob_with_check_digit");
        ((MRZResultModel)((Object)string)).sex = object.getString("sex");
        ((MRZResultModel)((Object)string)).expirationDateRaw = object.getString("expiration_date_raw");
        ((MRZResultModel)((Object)string)).expirationDateWithCheckDigit = object.getString("expiration_date_with_check_digit");
        ((MRZResultModel)((Object)string)).expirationDateReadable = object.getString("expiration_date_readable");
        ((MRZResultModel)((Object)string)).masterCheckDigit = object.getString("master_check_digit");
        ((MRZResultModel)((Object)string)).areCheckDigitsValid = object.getBoolean("are_check_digits_valid");
        JSONArray jSONArray = object.getJSONArray("given_names");
        if (jSONArray.length() > 0) {
            ((MRZResultModel)((Object)string)).givenNames = new String[jSONArray.length()];
            for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                ((MRZResultModel)((Object)string)).givenNames[n2] = jSONArray.getString(n2);
            }
        }
        if ((jSONArray = object.getJSONArray("surnames")).length() > 0) {
            ((MRZResultModel)((Object)string)).surnames = new String[jSONArray.length()];
            for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                ((MRZResultModel)((Object)string)).surnames[n2] = jSONArray.getString(n2);
            }
        }
        if ((object = object.getJSONArray("optionals")).length() > 0) {
            ((MRZResultModel)((Object)string)).optionals = new String[object.length()];
            for (int i2 = 0; i2 < object.length(); ++i2) {
                ((MRZResultModel)((Object)string)).optionals[i2] = object.getString(i2);
            }
        }
        MRZResultModel mRZResultModel = string;
        String string = mRZResultModel.documentTypeRaw;
        object = mRZResultModel.issuingCountry;
        String string2 = mRZResultModel.dobRaw;
        String string3 = mRZResultModel.expirationDateRaw;
        mRZResultModel.estIssuingDateRaw = mRZResultModel.calculateEstIssuingDate(string, (String)object, string2, string3);
        mRZResultModel.parseRawToReadable();
    }

    private String b(String string) {
        if (string != null && string.length() == 6) {
            int n2;
            String string2;
            try {
                string2 = string;
                n2 = Calendar.getInstance().get(1) % 100;
            }
            catch (NumberFormatException numberFormatException) {
                return "Unknown";
            }
            int n3 = Integer.parseInt(string2.substring(0, 2));
            n2 = n3 > n2 ? n3 + 1900 : n3 + 2000;
            return this.a(string, n2);
        }
        return "Unknown";
    }

    private String c(String string) {
        if (string != null && string.length() == 6) {
            int n2;
            block5: {
                try {
                    n2 = Integer.parseInt(string.substring(0, 2));
                    if (n2 < 70) {
                        n2 += 2000;
                        break block5;
                    }
                    n2 += 1900;
                }
                catch (NumberFormatException numberFormatException) {
                    return "Unknown";
                }
            }
            return this.a(string, n2);
        }
        return "Unknown";
    }

    private String a(String string, int n2) {
        Calendar calendar = Calendar.getInstance();
        String string2 = string;
        int n3 = Integer.parseInt(string2.substring(2, 4)) - 1;
        calendar.set(n2, n3, Integer.parseInt(string2.substring(4, 6)));
        return new SimpleDateFormat(MRZScanner.getDateFormat(), Locale.getDefault()).format(calendar.getTime());
    }

    private boolean a(String string) {
        return string != null && !string.isEmpty() && !string.equals("N/A");
    }

    static {
        System.loadLibrary("mrz-native-lib");
        CREATOR = new Parcelable.Creator(){

            public MRZResultModel createFromParcel(Parcel parcel) {
                return new MRZResultModel(parcel);
            }

            public MRZResultModel[] newArray(int n2) {
                return new MRZResultModel[n2];
            }
        };
    }

    public native String parseReadableDocumentType(String var1);

    public native String calculateEstIssuingDate(String var1, String var2, String var3, String var4);

    public native String parseDate(String var1);

    public String getFullName() {
        return this.givenNamesReadable() + " " + this.surnamesReadable();
    }

    public void parseRawToReadable() {
        MRZResultModel mRZResultModel = this;
        mRZResultModel.documentTypeReadable = mRZResultModel.parseReadableDocumentType(mRZResultModel.documentTypeRaw);
        mRZResultModel.dobReadable = mRZResultModel.b(mRZResultModel.dobRaw);
        mRZResultModel.expirationDateReadable = mRZResultModel.c(mRZResultModel.expirationDateRaw);
        mRZResultModel.estIssuingDateReadable = mRZResultModel.c(mRZResultModel.estIssuingDateRaw);
    }

    public String givenNamesReadable() {
        StringBuilder stringBuilder;
        if (((MRZResultModel)((Object)stringBuilder2)).givenNames == null) {
            return "";
        }
        MRZResultModel mRZResultModel = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String[] stringArray = mRZResultModel.givenNames;
        int n2 = mRZResultModel.givenNames.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder2.append(stringArray[i2]).append(" ");
        }
        return stringBuilder2.toString().trim();
    }

    public String surnamesReadable() {
        StringBuilder stringBuilder;
        if (((MRZResultModel)((Object)stringBuilder2)).surnames == null) {
            return "";
        }
        MRZResultModel mRZResultModel = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String[] stringArray = mRZResultModel.surnames;
        int n2 = mRZResultModel.surnames.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder2.append(stringArray[i2]).append(" ");
        }
        return stringBuilder2.toString().trim();
    }

    public String optionalsReadable() {
        StringBuilder stringBuilder;
        MRZResultModel mRZResultModel = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String[] stringArray = mRZResultModel.optionals;
        if (mRZResultModel.optionals != null) {
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder2.append(stringArray[i2]).append(" ");
            }
        }
        return stringBuilder2.toString().trim();
    }

    public String dob_check_digit() {
        MRZResultModel mRZResultModel = this;
        if (mRZResultModel.a(mRZResultModel.dobWithCheckDigit)) {
            String string = this.dobWithCheckDigit;
            return string.substring(string.length() - 1);
        }
        return null;
    }

    public String expiration_date_check_digit() {
        MRZResultModel mRZResultModel = this;
        if (mRZResultModel.a(mRZResultModel.expirationDateWithCheckDigit)) {
            String string = this.expirationDateWithCheckDigit;
            return string.substring(string.length() - 1);
        }
        return null;
    }

    public String document_number_check_digit() {
        MRZResultModel mRZResultModel = this;
        if (mRZResultModel.a(mRZResultModel.documentNumberWithCheckDigit)) {
            String string = this.documentNumberWithCheckDigit;
            return string.substring(string.length() - 1);
        }
        return null;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject2.put("document_type_raw", (Object)this.documentTypeRaw);
        jSONObject2.put("document_type_readable", (Object)this.documentTypeReadable);
        jSONObject2.put("issuing_country", (Object)this.issuingCountry);
        jSONObject2.put("surname", (Object)this.surnamesReadable());
        jSONObject2.put("document_number", (Object)this.documentNumber);
        jSONObject2.put("document_number_with_check_digit", (Object)this.documentNumberWithCheckDigit);
        jSONObject2.put("document_number_check_digit", (Object)this.document_number_check_digit());
        jSONObject2.put("nationality", (Object)this.nationality);
        jSONObject2.put("dob_raw", (Object)this.dobRaw);
        jSONObject2.put("dob_with_check_digit", (Object)this.dobWithCheckDigit);
        jSONObject2.put("dob_check_digit", (Object)this.dob_check_digit());
        jSONObject2.put("dob_readable", (Object)this.dobReadable);
        jSONObject2.put("sex", (Object)this.sex);
        jSONObject2.put("est_issuing_date_raw", (Object)this.estIssuingDateRaw);
        jSONObject2.put("est_issuing_date_readable", (Object)this.estIssuingDateReadable);
        jSONObject2.put("expiration_date_raw", (Object)this.expirationDateRaw);
        jSONObject2.put("expiration_date_with_check_digit", (Object)this.expirationDateWithCheckDigit);
        jSONObject2.put("expiration_date_check_digit", (Object)this.expiration_date_check_digit());
        jSONObject2.put("expiration_date_readable", (Object)this.expirationDateReadable);
        jSONObject2.put("master_check_digit", (Object)this.masterCheckDigit);
        jSONObject2.put("given_names_readable", (Object)this.givenNamesReadable());
        jSONObject.put("optionals", (Object)this.optionalsReadable());
        return jSONObject;
    }

    public boolean isExpired() {
        if (this.expirationDateRaw.length() == 6 && !this.expirationDateRaw.contains("*")) {
            int n2 = Integer.parseInt(this.expirationDateRaw.substring(0, 2));
            n2 = n2 < 70 ? (n2 += 2000) : (n2 += 1900);
            Calendar calendar = Calendar.getInstance();
            MRZResultModel mRZResultModel = this;
            int n3 = Integer.parseInt(mRZResultModel.expirationDateRaw.substring(2, 4)) - 1;
            calendar.set(n2, n3, Integer.parseInt(mRZResultModel.expirationDateRaw.substring(4, 6)));
            return calendar.before(Calendar.getInstance());
        }
        return false;
    }

    public String toCSV() {
        return this.documentTypeRaw + "," + this.documentTypeReadable + "," + this.issuingCountry + "," + this.surnamesReadable() + "," + this.givenNamesReadable() + "," + this.documentNumber + "," + this.documentNumberWithCheckDigit + "," + this.document_number_check_digit() + "," + this.nationality + "," + this.dobRaw + "," + this.dobWithCheckDigit + "," + this.dob_check_digit() + "," + this.dobReadable + "," + this.sex + "," + this.estIssuingDateRaw + "," + this.estIssuingDateReadable + "," + this.expirationDateRaw + "," + this.expirationDateWithCheckDigit + "," + this.expiration_date_check_digit() + "," + this.expirationDateReadable + "," + this.masterCheckDigit + "," + this.optionalsReadable() + "," + this.dateScanned;
    }

    public String toReadableString() {
        return "Document number:  " + this.documentNumber + "\nFull name:  " + this.getFullName() + "\nNationality:  " + this.nationality + "\nIssuing country:  " + this.issuingCountry + "\nSex:  " + this.sex + "\nDate of birth:  " + this.dobReadable + "\nDate of birth (raw):  " + this.dobRaw + "\nExpiration date:  " + this.expirationDateReadable + "\nExpiration date (raw):  " + this.expirationDateRaw + "\nEstimated issuing date:  " + this.estIssuingDateReadable + "\nEstimated issuing date (raw):  " + this.estIssuingDateRaw + "\nOptional value:  " + this.optionalsReadable();
    }

    public boolean isId() {
        return this.documentTypeRaw.startsWith("I") || this.documentTypeRaw.startsWith("A") || this.documentTypeRaw.startsWith("C");
    }

    public boolean isPassport() {
        return this.documentTypeRaw.startsWith("P");
    }

    public boolean isVisa() {
        return this.documentTypeRaw.startsWith("V");
    }

    public boolean isResidencePermit() {
        return this.documentTypeRaw.startsWith("A");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.rawResult);
        parcel.writeString(this.documentTypeRaw);
        parcel.writeString(this.issuingCountry);
        parcel.writeStringArray(this.surnames);
        parcel.writeStringArray(this.givenNames);
        parcel.writeString(this.documentNumber);
        parcel.writeString(this.documentNumberWithCheckDigit);
        parcel.writeString(this.nationality);
        parcel.writeString(this.dobRaw);
        parcel.writeString(this.dobWithCheckDigit);
        parcel.writeString(this.sex);
        parcel.writeString(this.estIssuingDateRaw);
        parcel.writeString(this.expirationDateRaw);
        parcel.writeString(this.expirationDateWithCheckDigit);
        parcel.writeString(this.masterCheckDigit);
        parcel.writeInt(this.areCheckDigitsValid ? 1 : 0);
        parcel.writeStringArray(this.optionals);
        parcel.writeLong(this.dateScanned);
        parcel.writeValue((Object)this.portrait);
        parcel.writeValue((Object)this.signature);
        parcel.writeValue((Object)this.fullImage);
        parcel.writeValue((Object)this.idBack);
        parcel.writeValue((Object)this.idFront);
    }
}

