/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.nio.ByteBuffer;
import org.opencv.core.CvType;
import org.opencv.core.Size;

public class Mat {
    public final long nativeObj;

    public Mat(long l) {
        if (l != 0L) {
            this.nativeObj = l;
            return;
        }
        throw new UnsupportedOperationException("Native object address is NULL");
    }

    public Mat() {
        this.nativeObj = Mat.n_Mat();
    }

    public Mat(int n, int n2, int n3) {
        this.nativeObj = Mat.n_Mat(n, n2, n3);
    }

    public Mat(int n, int n2, int n3, ByteBuffer byteBuffer) {
        this.nativeObj = Mat.n_Mat(n, n2, n3, byteBuffer);
    }

    public Mat(Size size, int n) {
        this.nativeObj = Mat.n_Mat(size.width, size.height, n);
    }

    public static Mat diag(Mat mat) {
        return new Mat(Mat.n_diag(mat.nativeObj));
    }

    public static Mat eye(int n, int n2, int n3) {
        return new Mat(Mat.n_eye(n, n2, n3));
    }

    public static Mat eye(Size size, int n) {
        return new Mat(Mat.n_eye(size.width, size.height, n));
    }

    public static Mat ones(int n, int n2, int n3) {
        return new Mat(Mat.n_ones(n, n2, n3));
    }

    public static Mat ones(Size size, int n) {
        return new Mat(Mat.n_ones(size.width, size.height, n));
    }

    public static Mat zeros(int n, int n2, int n3) {
        return new Mat(Mat.n_zeros(n, n2, n3));
    }

    public static Mat zeros(Size size, int n) {
        return new Mat(Mat.n_zeros(size.width, size.height, n));
    }

    private static native long n_Mat();

    private static native long n_Mat(int var0, int var1, int var2);

    private static native long n_Mat(int var0, int var1, int var2, ByteBuffer var3);

    private static native long n_Mat(double var0, double var2, int var4);

    private static native long n_adjustROI(long var0, int var2, int var3, int var4, int var5);

    private static native void n_assignTo(long var0, long var2, int var4);

    private static native void n_assignTo(long var0, long var2);

    private static native int n_channels(long var0);

    private static native int n_checkVector(long var0, int var2, int var3, boolean var4);

    private static native int n_checkVector(long var0, int var2, int var3);

    private static native int n_checkVector(long var0, int var2);

    private static native long n_clone(long var0);

    private static native long n_col(long var0, int var2);

    private static native long n_colRange(long var0, int var2, int var3);

    private static native int n_dims(long var0);

    private static native int n_cols(long var0);

    private static native void n_convertTo(long var0, long var2, int var4, double var5, double var7);

    private static native void n_convertTo(long var0, long var2, int var4, double var5);

    private static native void n_convertTo(long var0, long var2, int var4);

    private static native void n_copyTo(long var0, long var2);

    private static native void n_copyTo(long var0, long var2, long var4);

    private static native void n_create(long var0, int var2, int var3, int var4);

    private static native void n_create(long var0, double var2, double var4, int var6);

    private static native long n_cross(long var0, long var2);

    private static native long n_dataAddr(long var0);

    private static native int n_depth(long var0);

    private static native long n_diag(long var0, int var2);

    private static native long n_diag(long var0);

    private static native double n_dot(long var0, long var2);

    private static native long n_elemSize(long var0);

    private static native long n_elemSize1(long var0);

    private static native boolean n_empty(long var0);

    private static native long n_eye(int var0, int var1, int var2);

    private static native long n_eye(double var0, double var2, int var4);

    private static native long n_inv(long var0, int var2);

    private static native long n_inv(long var0);

    private static native boolean n_isContinuous(long var0);

    private static native boolean n_isSubmatrix(long var0);

    private static native long n_mul(long var0, long var2, double var4);

    private static native long n_mul(long var0, long var2);

    private static native long n_ones(int var0, int var1, int var2);

    private static native long n_ones(double var0, double var2, int var4);

    private static native void n_push_back(long var0, long var2);

    private static native void n_release(long var0);

    private static native long n_reshape(long var0, int var2, int var3);

    private static native long n_reshape(long var0, int var2);

    private static native long n_reshape_1(long var0, int var2, int var3, int[] var4);

    private static native long n_row(long var0, int var2);

    private static native long n_rowRange(long var0, int var2, int var3);

    private static native int n_rows(long var0);

    private static native long n_setTo(long var0, long var2, long var4);

    private static native long n_setTo(long var0, long var2);

    private static native int n_size_i(long var0, int var2);

    private static native long n_step1(long var0, int var2);

    private static native long n_step1(long var0);

    private static native long n_submat_rr(long var0, int var2, int var3, int var4, int var5);

    private static native long n_t(long var0);

    private static native long n_total(long var0);

    private static native int n_type(long var0);

    private static native long n_zeros(int var0, int var1, int var2);

    private static native long n_zeros(double var0, double var2, int var4);

    private static native void n_delete(long var0);

    private static native int nPutD(long var0, int var2, int var3, int var4, double[] var5);

    private static native int nPutF(long var0, int var2, int var3, int var4, float[] var5);

    private static native int nPutI(long var0, int var2, int var3, int var4, int[] var5);

    private static native int nPutS(long var0, int var2, int var3, int var4, short[] var5);

    private static native int nPutB(long var0, int var2, int var3, int var4, byte[] var5);

    private static native int nPutBwOffset(long var0, int var2, int var3, int var4, int var5, byte[] var6);

    private static native int nGetB(long var0, int var2, int var3, int var4, byte[] var5);

    private static native int nGetS(long var0, int var2, int var3, int var4, short[] var5);

    private static native int nGetI(long var0, int var2, int var3, int var4, int[] var5);

    private static native int nGetF(long var0, int var2, int var3, int var4, float[] var5);

    private static native int nGetD(long var0, int var2, int var3, int var4, double[] var5);

    private static native double[] nGet(long var0, int var2, int var3);

    private static native String nDump(long var0);

    public Mat adjustROI(int n, int n2, int n3, int n4) {
        return new Mat(Mat.n_adjustROI(this.nativeObj, n, n2, n3, n4));
    }

    public void assignTo(Mat mat, int n) {
        Mat.n_assignTo(this.nativeObj, mat.nativeObj, n);
    }

    public void assignTo(Mat mat) {
        Mat.n_assignTo(this.nativeObj, mat.nativeObj);
    }

    public int channels() {
        return Mat.n_channels(this.nativeObj);
    }

    public int checkVector(int n, int n2, boolean bl) {
        return Mat.n_checkVector(this.nativeObj, n, n2, bl);
    }

    public int checkVector(int n, int n2) {
        return Mat.n_checkVector(this.nativeObj, n, n2);
    }

    public int checkVector(int n) {
        return Mat.n_checkVector(this.nativeObj, n);
    }

    public Mat clone() {
        return new Mat(Mat.n_clone(this.nativeObj));
    }

    public Mat col(int n) {
        return new Mat(Mat.n_col(this.nativeObj, n));
    }

    public Mat colRange(int n, int n2) {
        return new Mat(Mat.n_colRange(this.nativeObj, n, n2));
    }

    public int dims() {
        return Mat.n_dims(this.nativeObj);
    }

    public int cols() {
        return Mat.n_cols(this.nativeObj);
    }

    public void convertTo(Mat mat, int n, double d2, double d3) {
        Mat.n_convertTo(this.nativeObj, mat.nativeObj, n, d2, d3);
    }

    public void convertTo(Mat mat, int n, double d2) {
        Mat.n_convertTo(this.nativeObj, mat.nativeObj, n, d2);
    }

    public void convertTo(Mat mat, int n) {
        Mat.n_convertTo(this.nativeObj, mat.nativeObj, n);
    }

    public void copyTo(Mat mat) {
        Mat.n_copyTo(this.nativeObj, mat.nativeObj);
    }

    public void copyTo(Mat mat, Mat mat2) {
        long l = mat.nativeObj;
        long l2 = mat2.nativeObj;
        Mat.n_copyTo(this.nativeObj, l, l2);
    }

    public void create(int n, int n2, int n3) {
        Mat.n_create(this.nativeObj, n, n2, n3);
    }

    public void create(Size size, int n) {
        Size size2 = size;
        double d2 = size2.width;
        double d3 = size2.height;
        Mat.n_create(this.nativeObj, d2, d3, n);
    }

    public Mat cross(Mat mat) {
        return new Mat(Mat.n_cross(this.nativeObj, mat.nativeObj));
    }

    public long dataAddr() {
        return Mat.n_dataAddr(this.nativeObj);
    }

    public int depth() {
        return Mat.n_depth(this.nativeObj);
    }

    public Mat diag(int n) {
        return new Mat(Mat.n_diag(this.nativeObj, n));
    }

    public Mat diag() {
        return new Mat(Mat.n_diag(this.nativeObj, 0));
    }

    public double dot(Mat mat) {
        return Mat.n_dot(this.nativeObj, mat.nativeObj);
    }

    public long elemSize() {
        return Mat.n_elemSize(this.nativeObj);
    }

    public long elemSize1() {
        return Mat.n_elemSize1(this.nativeObj);
    }

    public boolean empty() {
        return Mat.n_empty(this.nativeObj);
    }

    public Mat inv(int n) {
        return new Mat(Mat.n_inv(this.nativeObj, n));
    }

    public Mat inv() {
        return new Mat(Mat.n_inv(this.nativeObj));
    }

    public boolean isContinuous() {
        return Mat.n_isContinuous(this.nativeObj);
    }

    public boolean isSubmatrix() {
        return Mat.n_isSubmatrix(this.nativeObj);
    }

    public Mat mul(Mat mat, double d2) {
        return new Mat(Mat.n_mul(this.nativeObj, mat.nativeObj, d2));
    }

    public Mat mul(Mat mat) {
        return new Mat(Mat.n_mul(this.nativeObj, mat.nativeObj));
    }

    public void push_back(Mat mat) {
        Mat.n_push_back(this.nativeObj, mat.nativeObj);
    }

    public void release() {
        Mat.n_release(this.nativeObj);
    }

    public Mat reshape(int n, int n2) {
        return new Mat(Mat.n_reshape(this.nativeObj, n, n2));
    }

    public Mat reshape(int n) {
        return new Mat(Mat.n_reshape(this.nativeObj, n));
    }

    public Mat reshape(int n, int[] nArray) {
        return new Mat(Mat.n_reshape_1(this.nativeObj, n, nArray.length, nArray));
    }

    public Mat row(int n) {
        return new Mat(Mat.n_row(this.nativeObj, n));
    }

    public Mat rowRange(int n, int n2) {
        return new Mat(Mat.n_rowRange(this.nativeObj, n, n2));
    }

    public int rows() {
        return Mat.n_rows(this.nativeObj);
    }

    public Mat setTo(Mat mat, Mat mat2) {
        long l = mat.nativeObj;
        long l2 = mat2.nativeObj;
        return new Mat(Mat.n_setTo(this.nativeObj, l, l2));
    }

    public Mat setTo(Mat mat) {
        return new Mat(Mat.n_setTo(this.nativeObj, mat.nativeObj));
    }

    public int size(int n) {
        return Mat.n_size_i(this.nativeObj, n);
    }

    public long step1(int n) {
        return Mat.n_step1(this.nativeObj, n);
    }

    public long step1() {
        return Mat.n_step1(this.nativeObj);
    }

    public Mat submat(int n, int n2, int n3, int n4) {
        return new Mat(Mat.n_submat_rr(this.nativeObj, n, n2, n3, n4));
    }

    public Mat t() {
        return new Mat(Mat.n_t(this.nativeObj));
    }

    public long total() {
        return Mat.n_total(this.nativeObj);
    }

    public int type() {
        return Mat.n_type(this.nativeObj);
    }

    protected void finalize() {
        Mat mat = this;
        Mat.n_delete(mat.nativeObj);
        super.finalize();
    }

    public String toString() {
        return "Mat [ " + this.rows() + "*" + this.cols() + "*" + CvType.typeToString(this.type()) + ", isCont=" + this.isContinuous() + ", isSubmat=" + this.isSubmatrix() + ", nativeObj=0x" + Long.toHexString(this.nativeObj) + ", dataAddr=0x" + Long.toHexString(this.dataAddr()) + " ]";
    }

    public String dump() {
        return Mat.nDump(this.nativeObj);
    }

    public int put(int n, int n2, double ... dArray) {
        int n3 = ((Mat)this).type();
        if (dArray != null && dArray.length % CvType.channels(n3) == 0) {
            return Mat.nPutD(((Mat)this).nativeObj, n, n2, dArray.length, dArray);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = dArray == null ? 0 : dArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public int put(int n, int n2, float[] fArray) {
        int n3 = ((Mat)this).type();
        if (fArray != null && fArray.length % CvType.channels(n3) == 0) {
            if (CvType.depth(n3) == 5) {
                return Mat.nPutF(((Mat)this).nativeObj, n, n2, fArray.length, fArray);
            }
            throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = fArray == null ? 0 : fArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public int put(int n, int n2, int[] nArray) {
        int n3 = ((Mat)this).type();
        if (nArray != null && nArray.length % CvType.channels(n3) == 0) {
            if (CvType.depth(n3) == 4) {
                return Mat.nPutI(((Mat)this).nativeObj, n, n2, nArray.length, nArray);
            }
            throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = nArray == null ? 0 : nArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public int put(int n, int n2, short[] sArray) {
        int n3 = ((Mat)this).type();
        if (sArray != null && sArray.length % CvType.channels(n3) == 0) {
            if (CvType.depth(n3) != 2 && CvType.depth(n3) != 3) {
                throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
            }
            return Mat.nPutS(((Mat)this).nativeObj, n, n2, sArray.length, sArray);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = sArray == null ? 0 : sArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public int put(int n, int n2, byte[] byArray) {
        int n3 = ((Mat)this).type();
        if (byArray != null && byArray.length % CvType.channels(n3) == 0) {
            if (CvType.depth(n3) != 0 && CvType.depth(n3) != 1) {
                throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
            }
            return Mat.nPutB(((Mat)this).nativeObj, n, n2, byArray.length, byArray);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = byArray == null ? 0 : byArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public int put(int n, int n2, byte[] byArray, int n3, int n4) {
        int n5 = ((Mat)this).type();
        if (byArray != null && n4 % CvType.channels(n5) == 0) {
            if (CvType.depth(n5) != 0 && CvType.depth(n5) != 1) {
                throw new UnsupportedOperationException("Mat data type is not compatible: " + n5);
            }
            return Mat.nPutBwOffset(((Mat)this).nativeObj, n, n2, n4, n3, byArray);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = byArray == null ? 0 : byArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n5)).append(")").toString());
        throw object;
    }

    public int get(int n, int n2, byte[] byArray) {
        int n3 = ((Mat)this).type();
        if (byArray != null && byArray.length % CvType.channels(n3) == 0) {
            if (CvType.depth(n3) != 0 && CvType.depth(n3) != 1) {
                throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
            }
            return Mat.nGetB(((Mat)this).nativeObj, n, n2, byArray.length, byArray);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = byArray == null ? 0 : byArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public int get(int n, int n2, short[] sArray) {
        int n3 = ((Mat)this).type();
        if (sArray != null && sArray.length % CvType.channels(n3) == 0) {
            if (CvType.depth(n3) != 2 && CvType.depth(n3) != 3) {
                throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
            }
            return Mat.nGetS(((Mat)this).nativeObj, n, n2, sArray.length, sArray);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = sArray == null ? 0 : sArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public int get(int n, int n2, int[] nArray) {
        int n3 = ((Mat)this).type();
        if (nArray != null && nArray.length % CvType.channels(n3) == 0) {
            if (CvType.depth(n3) == 4) {
                return Mat.nGetI(((Mat)this).nativeObj, n, n2, nArray.length, nArray);
            }
            throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = nArray == null ? 0 : nArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public int get(int n, int n2, float[] fArray) {
        int n3 = ((Mat)this).type();
        if (fArray != null && fArray.length % CvType.channels(n3) == 0) {
            if (CvType.depth(n3) == 5) {
                return Mat.nGetF(((Mat)this).nativeObj, n, n2, fArray.length, fArray);
            }
            throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = fArray == null ? 0 : fArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public int get(int n, int n2, double[] dArray) {
        int n3 = ((Mat)this).type();
        if (dArray != null && dArray.length % CvType.channels(n3) == 0) {
            if (CvType.depth(n3) == 6) {
                return Mat.nGetD(((Mat)this).nativeObj, n, n2, dArray.length, dArray);
            }
            throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Provided data element number (");
        n2 = dArray == null ? 0 : dArray.length;
        Object object = this;
        ((UnsupportedOperationException)object)(stringBuilder.append(n2).append(") should be multiple of the Mat channels count (").append(CvType.channels(n3)).append(")").toString());
        throw object;
    }

    public double[] get(int n, int n2) {
        return Mat.nGet(this.nativeObj, n, n2);
    }

    public int height() {
        return this.rows();
    }

    public int width() {
        return this.cols();
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }
}

