package org.opencv.android;

import org.opencv.core.Core;

import java.util.StringTokenizer;

class StaticHelper {

    static void initOpenCV()
    {
        String libs = "";

        try
        {
            System.loadLibrary("opencv_info");
            libs = getLibraryList();
        }
        catch(UnsatisfiedLinkError ignored) {}

        if (initOpenCVLibs(libs))
        {
            String eol = System.getProperty("line.separator");
            Core.getBuildInformation().split(eol);
        }
    }

    private static boolean loadLibrary(String Name)
    {
        boolean result = true;

        try
        {
            System.loadLibrary(Name);
        } catch(UnsatisfiedLinkError e) {
            e.printStackTrace();
            result = false;
        }

        return result;
    }

    private static boolean initOpenCVLibs(String Libs)
    {
        boolean result = true;

        if ((null != Libs) && (Libs.length() != 0)) {
            StringTokenizer splitter = new StringTokenizer(Libs, ";");
            while(splitter.hasMoreTokens())
            {
                result &= loadLibrary(splitter.nextToken());
            }
        } else {
            result = loadLibrary("opencv_java3");
        }

        return result;
    }

    private static native String getLibraryList();
}
