package com.scansolutions.mrzscannerlib;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore.Images.ImageColumns;
import android.support.annotation.Nullable;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import static com.scansolutions.mrzscannerlib.ImageUtils.rotateImage;

public class ImagePickerActivity extends Activity {

    public static final int RESULT_LOAD_IMG = 8888;
    private static MRZScannerListener scannerListener;

    static void start(final Context context, MRZScannerListener listener) {
        scannerListener = listener;
        final Intent intent = new Intent(context, ImagePickerActivity.class)
                .addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.image_picker_activity);
        Intent pickerIntent = new Intent(Intent.ACTION_PICK);
        pickerIntent.setType("image/*");
        startActivityForResult(pickerIntent, RESULT_LOAD_IMG);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == RESULT_LOAD_IMG) {
            if (resultCode == RESULT_OK) {
//                MRZScanner.registerWithLicenseKey(this, key);
                scanImagePickerResult(data, this);
            } else {
                scannerListener.scanImageFailed();
                finishOnMainThread();
            }
        }
    }

    private void scanImagePickerResult(final Intent data, final Context c) {
        new Thread(new Runnable() {

            @Override
            public void run() {
                try {
                    Uri uri = data.getData();
                    ContentResolver contentResolver = c.getContentResolver();
                    InputStream imageStream = contentResolver.openInputStream(uri);
                    Bitmap selectedImage = BitmapFactory.decodeStream(imageStream);

                    String realPath = getRealPathFromURI(uri, contentResolver);

                    ExifInterface ei = new ExifInterface(realPath);
                    int orientation = ei.getAttributeInt(ExifInterface.TAG_ORIENTATION,
                            ExifInterface.ORIENTATION_UNDEFINED);

                    final Bitmap rotatedBitmap;
                    switch (orientation) {

                        case ExifInterface.ORIENTATION_ROTATE_90:
                            rotatedBitmap = rotateImage(selectedImage, 90);
                            break;

                        case ExifInterface.ORIENTATION_ROTATE_180:
                            rotatedBitmap = rotateImage(selectedImage, 180);
                            break;

                        case ExifInterface.ORIENTATION_ROTATE_270:
                            rotatedBitmap = rotateImage(selectedImage, 270);
                            break;

                        case ExifInterface.ORIENTATION_NORMAL:
                        default:
                            rotatedBitmap = selectedImage;
                    }

                    MRZCore.scanningRectX = 0;
                    MRZCore.scanningRectY = 0;
                    MRZCore.width = 100;
                    MRZCore.height = 100;

                    new MRZCore(null, null, scannerListener, c)
                            .scanForMRZ(rotatedBitmap);
                } catch (FileNotFoundException e) {
                    MRZCore.triggerScanImageFailedOnMainThread(scannerListener);
                } catch (IOException e) {
                    MRZCore.triggerScanImageFailedOnMainThread(scannerListener);
                }

                finishOnMainThread();
            }
        }).start();
    }

    private static String getRealPathFromURI(Uri contentURI, ContentResolver contentResolver) {
        Cursor cursor = contentResolver.query(contentURI, null, null, null, null);
        if (cursor == null) {
            return contentURI.getPath();
        } else {
            cursor.moveToFirst();
            int idx = cursor.getColumnIndex(ImageColumns.DATA);
            String path = cursor.getString(idx);
            cursor.close();
            return path;
        }
    }

    private void finishOnMainThread() {
        new Handler(Looper.getMainLooper()).post(new Runnable() {
            @Override
            public void run() {
                ImagePickerActivity.this.finish();
            }
        });
    }

}
