/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.scansolutions.mrzscannerlib.R;
import java.util.List;
import org.opencv.android.FpsMeter;
import org.opencv.android.Utils;
import org.opencv.core.Mat;
import org.opencv.core.Size;

public abstract class CameraBridgeViewBase
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = "CameraBridge";
    private static final int MAX_UNSPECIFIED = -1;
    private static final int STOPPED = 0;
    private static final int STARTED = 1;
    private int mState = 0;
    private Bitmap mCacheBitmap;
    private CvCameraViewListener2 mListener;
    private boolean mSurfaceExist;
    private Object mSyncObject = new Object();
    protected int mFrameWidth;
    protected int mFrameHeight;
    protected int mMaxHeight;
    protected int mMaxWidth;
    protected float mScale = 0.0f;
    protected int mPreviewFormat = 1;
    protected int mCameraIndex = -1;
    protected boolean mEnabled;
    protected FpsMeter mFpsMeter = null;
    public static final int CAMERA_ID_ANY = -1;
    public static final int CAMERA_ID_BACK = 99;
    public static final int CAMERA_ID_FRONT = 98;
    public static final int RGBA = 1;
    public static final int GRAY = 2;

    public CameraBridgeViewBase(Context context, int cameraId) {
        super(context);
        this.mCameraIndex = cameraId;
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mMaxWidth = -1;
        this.mMaxHeight = -1;
    }

    public CameraBridgeViewBase(Context context, AttributeSet attrs) {
        super(context, attrs);
        int count = attrs.getAttributeCount();
        Log.d((String)TAG, (String)("Attr count: " + Integer.valueOf(count)));
        TypedArray styledAttrs = this.getContext().obtainStyledAttributes(attrs, R.styleable.CameraBridgeViewBase);
        if (styledAttrs.getBoolean(R.styleable.CameraBridgeViewBase_show_fps, false)) {
            this.enableFpsMeter();
        }
        this.mCameraIndex = styledAttrs.getInt(R.styleable.CameraBridgeViewBase_camera_id, -1);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mMaxWidth = -1;
        this.mMaxHeight = -1;
        styledAttrs.recycle();
    }

    public void setCameraIndex(int cameraIndex) {
        this.mCameraIndex = cameraIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceChanged(SurfaceHolder arg0, int arg1, int arg2, int arg3) {
        Log.d((String)TAG, (String)"call surfaceChanged event");
        Object object = this.mSyncObject;
        synchronized (object) {
            if (!this.mSurfaceExist) {
                this.mSurfaceExist = true;
                this.checkCurrentState();
            } else {
                this.mSurfaceExist = false;
                this.checkCurrentState();
                this.mSurfaceExist = true;
                this.checkCurrentState();
            }
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder holder) {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.mSurfaceExist = false;
            this.checkCurrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableView() {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.mEnabled = true;
            this.checkCurrentState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableView() {
        Object object = this.mSyncObject;
        synchronized (object) {
            this.mEnabled = false;
            this.checkCurrentState();
        }
    }

    public void enableFpsMeter() {
        if (this.mFpsMeter == null) {
            this.mFpsMeter = new FpsMeter();
            this.mFpsMeter.setResolution(this.mFrameWidth, this.mFrameHeight);
        }
    }

    public void disableFpsMeter() {
        this.mFpsMeter = null;
    }

    public void setCvCameraViewListener(CvCameraViewListener2 listener) {
        this.mListener = listener;
    }

    public void setCvCameraViewListener(CvCameraViewListener listener) {
        CvCameraViewListenerAdapter adapter = new CvCameraViewListenerAdapter(listener);
        adapter.setFrameFormat(this.mPreviewFormat);
        this.mListener = adapter;
    }

    public void setMaxFrameSize(int maxWidth, int maxHeight) {
        this.mMaxWidth = maxWidth;
        this.mMaxHeight = maxHeight;
    }

    public void SetCaptureFormat(int format) {
        this.mPreviewFormat = format;
        if (this.mListener instanceof CvCameraViewListenerAdapter) {
            CvCameraViewListenerAdapter adapter = (CvCameraViewListenerAdapter)this.mListener;
            adapter.setFrameFormat(this.mPreviewFormat);
        }
    }

    private void checkCurrentState() {
        Log.d((String)TAG, (String)"call checkCurrentState");
        int targetState = this.mEnabled && this.mSurfaceExist && this.getVisibility() == 0 ? 1 : 0;
        if (targetState != this.mState) {
            this.processExitState(this.mState);
            this.mState = targetState;
            this.processEnterState(this.mState);
        }
    }

    private void processEnterState(int state) {
        Log.d((String)TAG, (String)("call processEnterState: " + state));
        switch (state) {
            case 1: {
                this.onEnterStartedState();
                if (this.mListener == null) break;
                this.mListener.onCameraViewStarted(this.mFrameWidth, this.mFrameHeight);
                break;
            }
            case 0: {
                this.onEnterStoppedState();
                if (this.mListener == null) break;
                this.mListener.onCameraViewStopped();
            }
        }
    }

    private void processExitState(int state) {
        Log.d((String)TAG, (String)("call processExitState: " + state));
        switch (state) {
            case 1: {
                this.onExitStartedState();
                break;
            }
            case 0: {
                this.onExitStoppedState();
            }
        }
    }

    private void onEnterStoppedState() {
    }

    private void onExitStoppedState() {
    }

    private void onEnterStartedState() {
        Log.d((String)TAG, (String)"call onEnterStartedState");
        if (!this.connectCamera(this.getWidth(), this.getHeight())) {
            AlertDialog ad = new AlertDialog.Builder(this.getContext()).create();
            ad.setCancelable(false);
            ad.setMessage((CharSequence)"It seems that you device does not support camera (or it is locked). Application will be closed.");
            ad.setButton(-3, (CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    ((Activity)CameraBridgeViewBase.this.getContext()).finish();
                }
            });
            ad.show();
        }
    }

    private void onExitStartedState() {
        this.disconnectCamera();
        if (this.mCacheBitmap != null) {
            this.mCacheBitmap.recycle();
        }
    }

    protected void deliverAndDrawFrame(CvCameraViewFrame frame) {
        Canvas canvas;
        Mat modified = this.mListener != null ? this.mListener.onCameraFrame(frame) : frame.rgba();
        boolean bmpValid = true;
        if (modified != null) {
            try {
                Utils.matToBitmap(modified, this.mCacheBitmap);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("Mat type: " + modified));
                Log.e((String)TAG, (String)("Bitmap type: " + this.mCacheBitmap.getWidth() + "*" + this.mCacheBitmap.getHeight()));
                Log.e((String)TAG, (String)("Utils.matToBitmap() throws an exception: " + e.getMessage()));
                bmpValid = false;
            }
        }
        if (bmpValid && this.mCacheBitmap != null && (canvas = this.getHolder().lockCanvas()) != null) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            Log.d((String)TAG, (String)("mStretch value: " + this.mScale));
            if (this.mScale != 0.0f) {
                canvas.drawBitmap(this.mCacheBitmap, new Rect(0, 0, this.mCacheBitmap.getWidth(), this.mCacheBitmap.getHeight()), new Rect((int)(((float)canvas.getWidth() - this.mScale * (float)this.mCacheBitmap.getWidth()) / 2.0f), (int)(((float)canvas.getHeight() - this.mScale * (float)this.mCacheBitmap.getHeight()) / 2.0f), (int)(((float)canvas.getWidth() - this.mScale * (float)this.mCacheBitmap.getWidth()) / 2.0f + this.mScale * (float)this.mCacheBitmap.getWidth()), (int)(((float)canvas.getHeight() - this.mScale * (float)this.mCacheBitmap.getHeight()) / 2.0f + this.mScale * (float)this.mCacheBitmap.getHeight())), null);
            } else {
                canvas.drawBitmap(this.mCacheBitmap, new Rect(0, 0, this.mCacheBitmap.getWidth(), this.mCacheBitmap.getHeight()), new Rect((canvas.getWidth() - this.mCacheBitmap.getWidth()) / 2, (canvas.getHeight() - this.mCacheBitmap.getHeight()) / 2, (canvas.getWidth() - this.mCacheBitmap.getWidth()) / 2 + this.mCacheBitmap.getWidth(), (canvas.getHeight() - this.mCacheBitmap.getHeight()) / 2 + this.mCacheBitmap.getHeight()), null);
            }
            if (this.mFpsMeter != null) {
                this.mFpsMeter.measure();
                this.mFpsMeter.draw(canvas, 20.0f, 30.0f);
            }
            this.getHolder().unlockCanvasAndPost(canvas);
        }
    }

    protected abstract boolean connectCamera(int var1, int var2);

    protected abstract void disconnectCamera();

    protected void AllocateCache() {
        this.mCacheBitmap = Bitmap.createBitmap((int)this.mFrameWidth, (int)this.mFrameHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    protected Size calculateCameraFrameSize(List<?> supportedSizes, ListItemAccessor accessor, int surfaceWidth, int surfaceHeight) {
        int calcWidth = 0;
        int calcHeight = 0;
        int maxAllowedWidth = this.mMaxWidth != -1 && this.mMaxWidth < surfaceWidth ? this.mMaxWidth : surfaceWidth;
        int maxAllowedHeight = this.mMaxHeight != -1 && this.mMaxHeight < surfaceHeight ? this.mMaxHeight : surfaceHeight;
        for (Object size : supportedSizes) {
            int width = accessor.getWidth(size);
            int height = accessor.getHeight(size);
            if (width > maxAllowedWidth || height > maxAllowedHeight || width < calcWidth || height < calcHeight) continue;
            calcWidth = width;
            calcHeight = height;
        }
        return new Size(calcWidth, calcHeight);
    }

    public static interface ListItemAccessor {
        public int getWidth(Object var1);

        public int getHeight(Object var1);
    }

    public static interface CvCameraViewFrame {
        public Mat rgba();

        public Mat gray();
    }

    protected class CvCameraViewListenerAdapter
    implements CvCameraViewListener2 {
        private int mPreviewFormat = 1;
        private CvCameraViewListener mOldStyleListener;

        public CvCameraViewListenerAdapter(CvCameraViewListener oldStypeListener) {
            this.mOldStyleListener = oldStypeListener;
        }

        @Override
        public void onCameraViewStarted(int width, int height) {
            this.mOldStyleListener.onCameraViewStarted(width, height);
        }

        @Override
        public void onCameraViewStopped() {
            this.mOldStyleListener.onCameraViewStopped();
        }

        @Override
        public Mat onCameraFrame(CvCameraViewFrame inputFrame) {
            Mat result = null;
            switch (this.mPreviewFormat) {
                case 1: {
                    result = this.mOldStyleListener.onCameraFrame(inputFrame.rgba());
                    break;
                }
                case 2: {
                    result = this.mOldStyleListener.onCameraFrame(inputFrame.gray());
                    break;
                }
                default: {
                    Log.e((String)CameraBridgeViewBase.TAG, (String)"Invalid frame format! Only RGBA and Gray Scale are supported!");
                }
            }
            return result;
        }

        public void setFrameFormat(int format) {
            this.mPreviewFormat = format;
        }
    }

    public static interface CvCameraViewListener2 {
        public void onCameraViewStarted(int var1, int var2);

        public void onCameraViewStopped();

        public Mat onCameraFrame(CvCameraViewFrame var1);
    }

    public static interface CvCameraViewListener {
        public void onCameraViewStarted(int var1, int var2);

        public void onCameraViewStopped();

        public Mat onCameraFrame(Mat var1);
    }
}

