/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.view.LayoutInflater;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.scansolutions.mrzscannerlib.AutoFitTextureView;
import com.scansolutions.mrzscannerlib.Camera1Impl;
import com.scansolutions.mrzscannerlib.Camera2Impl;
import com.scansolutions.mrzscannerlib.MRZCore;
import com.scansolutions.mrzscannerlib.MRZOverlay;
import com.scansolutions.mrzscannerlib.MRZScannerListener;
import com.scansolutions.mrzscannerlib.R;
import com.scansolutions.mrzscannerlib.ScannerType;

public class MRZScanner
extends Fragment
implements Camera2Impl.CameraInitListener {
    private static final int REQUEST_CAMERA_PERMISSION = 1;
    private static final String FRAGMENT_DIALOG = "dialog";
    private static final int CAMERA_VERSION_1 = 1;
    private static final int CAMERA_VERSION_2 = 2;
    private static int cameraVersion = 2;
    private static final String TAG = "MRZCameraActivity";
    private AutoFitTextureView mTextureView;
    private ImageView debugPreview;
    private MRZOverlay mrzOverlay;
    private int x = 8;
    private int y = 20;
    private int width = 84;
    private int height = 60;
    private MRZScannerListener scannerListener;
    private Camera2Impl camera2Impl;
    private Camera1Impl camera1Impl;
    private static String dateFormat = "dd.MM.yyyy";

    public void onResume() {
        super.onResume();
        if (cameraVersion == 1) {
            this.camera1Impl.resume();
        } else if (cameraVersion == 2) {
            if (this.mTextureView.isAvailable()) {
                this.camera2Impl.openCamera2(this.mTextureView.getWidth(), this.mTextureView.getHeight());
            } else {
                this.mTextureView.setSurfaceTextureListener(this.camera2Impl.mSurfaceTextureListener);
            }
        }
        Button btnCapture = (Button)this.getView().findViewById(R.id.captureButton);
        if (MRZCore.scannerType == ScannerType.SCANNER_TYPE_DOC_IMAGE_ID) {
            btnCapture.setVisibility(0);
            btnCapture.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MRZCore.scanningState = 2;
                }
            });
        } else {
            btnCapture.setVisibility(8);
        }
    }

    public void onPause() {
        super.onPause();
        if (cameraVersion == 1) {
            this.camera1Impl.stopScanner();
        } else if (cameraVersion == 2) {
            this.camera2Impl.closeCamera2();
        }
    }

    private void requestCameraAndStoragePermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.shouldShowRequestPermissionRationale("android.permission.CAMERA") || this.shouldShowRequestPermissionRationale("android.permission.WRITE_EXTERNAL_STORAGE")) {
                new ConfirmationDialog().show(this.getFragmentManager(), FRAGMENT_DIALOG);
            } else {
                this.requestPermissions(new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 1 && grantResults.length > 0) {
            boolean permissionGranted = true;
            for (int grantResult : grantResults) {
                if (grantResult == 0) continue;
                permissionGranted = false;
            }
            if (!permissionGranted) {
                ErrorDialog.newInstance("The MRZ scanner cannot work without the requested permissions.").show(this.getFragmentManager(), FRAGMENT_DIALOG);
                return;
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    static boolean hasPermissions(Context context, String ... permissions) {
        if (context != null && permissions != null) {
            for (String permission2 : permissions) {
                if (ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void setScanningRectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.mrzOverlay.setRect(x, y, width, height);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        cameraVersion = Build.VERSION.SDK_INT >= 28 ? 2 : 1;
        this.getActivity().getWindow().setFlags(0x1000000, 0x1000000);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MRZCore.prepareTesseract((Context)MRZScanner.this.getActivity());
            }
        }).start();
        View v = inflater.inflate(R.layout.amrz_activity_scanner, container, false);
        ImageButton btnFlash = (ImageButton)v.findViewById(R.id.mrz_flash);
        this.mrzOverlay = (MRZOverlay)v.findViewById(R.id.mrz_overlay);
        this.mrzOverlay.setRect(this.x, this.y, this.width, this.height);
        if (cameraVersion == 1) {
            SurfaceView mSurfaceView = (SurfaceView)v.findViewById(R.id.preview_view);
            mSurfaceView.setVisibility(0);
            this.camera1Impl = new Camera1Impl((Context)this.getActivity(), mSurfaceView, btnFlash, this.mrzOverlay, this.debugPreview, this.scannerListener, this);
        } else if (cameraVersion == 2) {
            this.mTextureView = (AutoFitTextureView)v.findViewById(R.id.texture);
            this.mTextureView.setVisibility(0);
            this.camera2Impl = new Camera2Impl((Context)this.getActivity(), this.scannerListener, this.mTextureView, btnFlash, this, this.mrzOverlay, this.debugPreview);
        }
        return v;
    }

    @Override
    public void shouldRequestCameraPermission() {
        this.requestCameraAndStoragePermission();
    }

    @Override
    public void warnIncompatibleCamera() {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                new AlertDialog.Builder((Context)MRZScanner.this.getActivity()).setTitle(R.string.warning).setMessage(R.string.warning_message).setNeutralButton(17039370, null).show();
            }
        });
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.scannerListener = (MRZScannerListener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context.toString() + "MRZScannerListener must be implemented");
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.scannerListener = (MRZScannerListener)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + "MRZScannerListener must be implemented");
        }
    }

    public void setIDActive(boolean isIDActive) {
        MRZCore.isIDActive = isIDActive;
    }

    public void setPassportActive(boolean isPassportActive) {
        MRZCore.isPassportActive = isPassportActive;
    }

    public void setVisaActive(boolean isVisaActive) {
        MRZCore.isVisaActive = isVisaActive;
    }

    public void setMaxThreads(int maxThreads) {
        MRZCore.maxThreads = Math.min(MRZCore.AVAILABLE_THREADS, Math.max(maxThreads, 0));
    }

    public void setScannerType(ScannerType scannerType) {
        MRZCore.scannerType = scannerType;
        if (scannerType == ScannerType.SCANNER_TYPE_DOC_IMAGE_PASSPORT || scannerType == ScannerType.SCANNER_TYPE_DOC_IMAGE_ID) {
            this.setScanningRectangle(3, 25, 94, 50);
        } else {
            this.setScanningRectangle(8, 20, 84, 60);
        }
    }

    public void resumeScanning() {
        MRZCore.scanningState = 0;
    }

    public int registerWithLicenseKey(String key) {
        String bundleID = this.getActivity().getApplicationInfo().packageName;
        return MRZCore.registerWithLicenseKey(key, bundleID, Build.MODEL);
    }

    public static String sdkVersion() {
        return MRZCore.sdkVersionNative();
    }

    public static void setDateFormat(String dateFormat) {
        MRZScanner.dateFormat = dateFormat;
    }

    public static String getDateFormat() {
        return dateFormat;
    }

    public static class ConfirmationDialog
    extends DialogFragment {
        @NonNull
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new AlertDialog.Builder((Context)this.getActivity()).setMessage((CharSequence)"This app requires the camera and storage permission in order to scan and read MRZ").setPositiveButton((CharSequence)"Grant", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        ConfirmationDialog.this.getActivity().requestPermissions(new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
                    }
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Activity activity = ConfirmationDialog.this.getActivity();
                    if (activity != null) {
                        activity.finish();
                    }
                }
            }).create();
        }
    }

    public static class ErrorDialog
    extends DialogFragment {
        private static final String ARG_MESSAGE = "message";

        public static ErrorDialog newInstance(String message) {
            ErrorDialog dialog = new ErrorDialog();
            Bundle args = new Bundle();
            args.putString(ARG_MESSAGE, message);
            dialog.setArguments(args);
            return dialog;
        }

        @NonNull
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            final Activity activity = this.getActivity();
            return new AlertDialog.Builder((Context)activity).setMessage((CharSequence)this.getArguments().getString(ARG_MESSAGE)).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                    activity.finish();
                }
            }).create();
        }
    }
}

