/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import com.scansolutions.mrzscannerlib.ImageUtils;
import com.scansolutions.mrzscannerlib.R;

class MRZOverlay
extends RelativeLayout {
    private static int x = 0;
    private static int y = 0;
    private static int width;
    private static int height;
    private Context context;
    private Bitmap icon;
    private Bitmap icon90;
    private Bitmap icon180;
    private Bitmap icon270;
    private boolean layoutDrawn = false;
    private MRZLocationOverlay mrzLocationOverlay;
    Animation fadeOut;

    public MRZOverlay(Context context, AttributeSet attrs) {
        this(context, attrs, 10, 20, 80, 60);
    }

    public MRZOverlay(Context context, AttributeSet attrs, int x, int y, int width, int height) {
        super(context, attrs);
        this.context = context;
        MRZOverlay.x = x;
        MRZOverlay.y = y;
        MRZOverlay.width = width;
        MRZOverlay.height = height;
        this.icon = ImageUtils.getBitmap(context, R.drawable.amrz_ic_scan_border);
        Matrix matrix = new Matrix();
        matrix.postRotate(90.0f);
        this.icon90 = Bitmap.createBitmap((Bitmap)this.icon, (int)0, (int)0, (int)this.icon.getWidth(), (int)this.icon.getHeight(), (Matrix)matrix, (boolean)true);
        matrix.postRotate(180.0f);
        this.icon180 = Bitmap.createBitmap((Bitmap)this.icon, (int)0, (int)0, (int)this.icon.getWidth(), (int)this.icon.getHeight(), (Matrix)matrix, (boolean)true);
        matrix.postRotate(270.0f);
        this.icon270 = Bitmap.createBitmap((Bitmap)this.icon, (int)0, (int)0, (int)this.icon.getWidth(), (int)this.icon.getHeight(), (Matrix)matrix, (boolean)true);
        this.fadeOut = new AlphaAnimation(1.0f, 0.0f);
        this.fadeOut.setInterpolator((Interpolator)new AccelerateInterpolator());
        this.fadeOut.setStartOffset(0L);
        this.fadeOut.setDuration(1500L);
        this.fadeOut.setFillAfter(true);
    }

    public void setRect(int x, int y, int width, int height) {
        MRZOverlay.x = x;
        MRZOverlay.y = y;
        MRZOverlay.width = width;
        MRZOverlay.height = height;
        this.validateSizes();
        if (this.layoutDrawn) {
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int xP = (int)((float)x / 100.0f * (float)canvas.getWidth());
        int yP = (int)((float)y / 100.0f * (float)canvas.getHeight());
        int widthP = (int)((float)width / 100.0f * (float)canvas.getWidth());
        int heightP = (int)((float)height / 100.0f * (float)canvas.getHeight());
        canvas.drawBitmap(this.icon, (float)xP, (float)(yP + heightP - this.icon.getHeight()), null);
        canvas.drawBitmap(this.icon90, (float)xP, (float)yP, null);
        canvas.drawBitmap(this.icon180, (float)(xP + widthP - this.icon.getWidth()), (float)(yP + heightP - this.icon.getHeight()), null);
        canvas.drawBitmap(this.icon270, (float)(xP + widthP - this.icon.getWidth()), (float)yP, null);
        this.layoutDrawn = true;
    }

    private void validateSizes() {
        x = Math.max(0, x);
        x = Math.min(100, x);
        y = Math.max(0, y);
        y = Math.min(100, y);
        width = Math.max(0, width);
        width = Math.min(100, width);
        height = Math.max(0, height);
        height = Math.min(100, height);
    }

    public void drawLocationOverlay(final int[] points, final int imageWidth, final int imageHeight) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (MRZOverlay.this.mrzLocationOverlay == null) {
                    MRZOverlay.this.mrzLocationOverlay = new MRZLocationOverlay(MRZOverlay.this.context);
                    MRZOverlay.this.addView(MRZOverlay.this.mrzLocationOverlay);
                }
                MRZOverlay.this.mrzLocationOverlay.setLocationPoints(points, imageWidth, imageHeight);
                MRZOverlay.this.mrzLocationOverlay.clearAnimation();
                MRZOverlay.this.mrzLocationOverlay.startAnimation(MRZOverlay.this.fadeOut);
            }
        });
    }

    private class MRZLocationOverlay
    extends View {
        Point[] locationPoints;
        private float imageWidth;
        private float imageHeight;

        public MRZLocationOverlay(Context context) {
            super(context);
        }

        protected void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            float scaleX = (float)canvas.getWidth() / this.imageWidth;
            float scaleY = (float)canvas.getHeight() / this.imageHeight;
            if (this.locationPoints != null && this.locationPoints.length == 4) {
                Path path = new Path();
                path.moveTo((float)this.locationPoints[0].x * scaleX, (float)this.locationPoints[0].y * scaleY);
                for (int i = 1; i < this.locationPoints.length; ++i) {
                    path.lineTo((float)this.locationPoints[i].x * scaleX, (float)this.locationPoints[i].y * scaleY);
                }
                path.lineTo((float)this.locationPoints[0].x * scaleX, (float)this.locationPoints[0].y * scaleY);
                path.close();
                Paint paint = new Paint();
                paint.setColor(1632426083);
                paint.setStyle(Paint.Style.FILL);
                canvas.drawPath(path, paint);
                paint.setStrokeWidth(3.0f);
                paint.setColor(-447948701);
                paint.setStyle(Paint.Style.STROKE);
                canvas.drawPath(path, paint);
                paint.setStyle(Paint.Style.FILL);
                for (Point p : this.locationPoints) {
                    canvas.drawCircle((float)p.x * scaleX, (float)p.y * scaleY, 5.0f, paint);
                }
            }
        }

        public void setLocationPoints(int[] points, int imageWidth, int imageHeight) {
            if (this.applyLocationPoints(points, imageWidth, imageHeight)) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        MRZLocationOverlay.this.invalidate();
                    }
                });
            }
        }

        private boolean applyLocationPoints(int[] points, int imageWidth, int imageHeight) {
            boolean isLengthAcceptable;
            boolean bl = isLengthAcceptable = points.length == 8;
            if (isLengthAcceptable) {
                this.locationPoints = new Point[4];
                this.locationPoints[0] = new Point(points[0], points[1]);
                this.locationPoints[1] = new Point(points[2], points[3]);
                this.locationPoints[2] = new Point(points[4], points[5]);
                this.locationPoints[3] = new Point(points[6], points[7]);
                this.imageWidth = imageWidth;
                this.imageHeight = imageHeight;
            }
            return isLengthAcceptable;
        }
    }
}

