/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.Size;
import android.util.SparseIntArray;
import android.widget.ImageView;
import com.googlecode.tesseract.android.TessBaseAPI;
import com.scansolutions.mrzscannerlib.MRZOverlay;
import com.scansolutions.mrzscannerlib.MRZResultModel;
import com.scansolutions.mrzscannerlib.MRZScannerListener;
import com.scansolutions.mrzscannerlib.ScannerType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.opencv.android.Utils;
import org.opencv.core.Core;
import org.opencv.core.CvException;
import org.opencv.core.Mat;

class MRZCore {
    private static final String TAG = MRZCore.class.getSimpleName();
    boolean isTorchOn = false;
    private MRZScannerListener scannerListener;
    private static final SparseIntArray ORIENTATIONS;
    static boolean isIDActive;
    static boolean isPassportActive;
    static boolean isVisaActive;
    static final int STATE_SCANNING = 0;
    static final int STATE_STOPPED = 1;
    static final int STATE_FINDING_SQUARE = 2;
    private static final int FRAME_Q_THRESHOLD = 50;
    static int scanningState;
    static ScannerType scannerType;
    private static final String TESSDATA = "tessdata";
    private static final String DATA_PATH;
    static int activeThreads;
    static final int AVAILABLE_THREADS;
    static int maxThreads;
    private MRZOverlay mrzOverlay;
    private ImageView debugPreview;

    MRZCore(MRZOverlay mrzOverlay, ImageView debugPreview, MRZScannerListener scannerListener) {
        this.mrzOverlay = mrzOverlay;
        this.debugPreview = debugPreview;
        this.scannerListener = scannerListener;
    }

    static native int[] mrzLocationMat(long var0, long var2);

    static native long isTextID(String var0);

    static native long isTextPassport(String var0);

    static native long isTextVisa(String var0, boolean var1);

    static native String parseResultJSON(String var0, int var1);

    static native String sdkVersionNative();

    static native double frameQuality(long var0);

    static native int registerWithLicenseKey(String var0, String var1, String var2);

    static native long validateCountryCode(String var0);

    static native int faceDetection(long var0, long var2, long var4, String var6, String var7, int[] var8);

    static native int[] findDocumentImageNative(long var0, boolean var2);

    void scan(Mat imageGrab) {
        if (scannerType == ScannerType.SCANNER_TYPE_MRZ) {
            this.scanForMRZ(imageGrab);
        } else if (MRZCore.isScannerTypeDoc()) {
            this.scanForDocumentImage(imageGrab);
        }
    }

    private void scanForDocumentImage(Mat imageGrab) {
        double frameQuality;
        int imageWidth = imageGrab.cols();
        int imageHeight = imageGrab.rows();
        int[] locationSquare = MRZCore.findDocumentImageNative(imageGrab.getNativeObjAddr(), scannerType == ScannerType.SCANNER_TYPE_DOC_IMAGE_PASSPORT);
        this.mrzOverlay.drawLocationOverlay(locationSquare, imageWidth, imageHeight);
        if (locationSquare.length == 8 && (scanningState == 2 || scannerType == ScannerType.SCANNER_TYPE_DOC_IMAGE_PASSPORT) && (frameQuality = MRZCore.frameQuality(imageGrab.getNativeObjAddr())) > 50.0) {
            Log.i((String)TAG, (String)String.valueOf(frameQuality));
            scanningState = 1;
            final Bitmap bitmapImg = Bitmap.createBitmap((int)imageGrab.cols(), (int)imageGrab.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Utils.matToBitmap(imageGrab, bitmapImg);
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (MRZCore.this.scannerListener != null) {
                        MRZCore.this.scannerListener.successfulScanWithDocumentImage(bitmapImg);
                    }
                }
            });
        }
    }

    private void scanForMRZ(Mat imageGrab) {
        double frameQuality;
        Mat outputMat = new Mat();
        int[] mrzLocationSquare = MRZCore.mrzLocationMat(imageGrab.getNativeObjAddr(), outputMat.getNativeObjAddr());
        this.mrzOverlay.drawLocationOverlay(mrzLocationSquare, imageGrab.cols(), imageGrab.rows());
        if (!outputMat.empty() && (frameQuality = MRZCore.frameQuality(imageGrab.getNativeObjAddr())) > 50.0) {
            try {
                Bitmap bitmapImg = Bitmap.createBitmap((int)outputMat.cols(), (int)outputMat.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Utils.matToBitmap(outputMat, bitmapImg);
                String result = this.extractText(bitmapImg);
                if (result != null && !result.isEmpty()) {
                    result = result.replaceAll("\n", "").replaceAll(" ", "");
                    boolean foundSTH = isIDActive && MRZCore.isTextID(result) > 0L || isPassportActive && MRZCore.isTextPassport(result) > 0L;
                    boolean isCountryCodeValid = MRZCore.validateCountryCode(result) > 0L;
                    int visaSubtype = 0;
                    if (isVisaActive && !foundSTH) {
                        visaSubtype = (int)MRZCore.isTextVisa(result, isCountryCodeValid);
                        boolean bl = foundSTH = visaSubtype != 0;
                    }
                    if (foundSTH && scanningState != 1) {
                        scanningState = 1;
                        String finalResult = MRZCore.parseResultJSON(result, visaSubtype);
                        long dateScanned = System.currentTimeMillis() / 1000L;
                        final MRZResultModel resultModel = new MRZResultModel(finalResult, dateScanned);
                        if (resultModel.document_type_raw.startsWith("P")) {
                            ArrayList<Bitmap> images = this.scanForFaceAndSignature(imageGrab, resultModel.issuing_country, mrzLocationSquare);
                            resultModel.portrait = images.get(0);
                            resultModel.signature = images.get(1);
                        }
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                if (MRZCore.this.scannerListener != null) {
                                    MRZCore.this.scannerListener.successfulScanWithResult(resultModel);
                                }
                            }
                        });
                    }
                }
            }
            catch (CvException e) {
                Log.d((String)"Exception", (String)e.getMessage());
            }
        }
    }

    private String extractText(Bitmap bmp) {
        String extractedText = "";
        try {
            TessBaseAPI tessBaseApi = new TessBaseAPI();
            tessBaseApi.init(DATA_PATH, "mrz");
            tessBaseApi.setPageSegMode(6);
            tessBaseApi.setVariable("tessedit_char_whitelist", "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ<");
            tessBaseApi.setVariable("load_system_dawg", "false");
            tessBaseApi.setVariable("load_freq_dawg", "false");
            tessBaseApi.setImage(bmp);
            extractedText = tessBaseApi.getUTF8Text();
            tessBaseApi.end();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        return extractedText;
    }

    private ArrayList<Bitmap> scanForFaceAndSignature(Mat inputImage, String issuingCountry, int[] squre) {
        ArrayList<Bitmap> imagesList = new ArrayList<Bitmap>(2);
        Mat faceMat = new Mat();
        Mat signatureMat = new Mat();
        MRZCore.faceDetection(inputImage.getNativeObjAddr(), faceMat.getNativeObjAddr(), signatureMat.getNativeObjAddr(), DATA_PATH + TESSDATA, issuingCountry, squre);
        if (!faceMat.empty()) {
            Bitmap faceImg = Bitmap.createBitmap((int)faceMat.cols(), (int)faceMat.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Utils.matToBitmap(faceMat, faceImg);
            imagesList.add(0, faceImg);
        } else {
            imagesList.add(0, null);
        }
        if (!signatureMat.empty()) {
            Bitmap signatureImg = Bitmap.createBitmap((int)signatureMat.cols(), (int)signatureMat.rows(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Utils.matToBitmap(signatureMat, signatureImg);
            imagesList.add(1, signatureImg);
        } else {
            imagesList.add(1, null);
        }
        return imagesList;
    }

    static void prepareTesseract(Context context) {
        try {
            MRZCore.prepareDirectory(DATA_PATH + TESSDATA);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MRZCore.copyTessDataFiles(context);
    }

    private static void prepareDirectory(String path) {
        File dir = new File(path);
        if (!dir.mkdirs()) {
            Log.e((String)TAG, (String)("ERROR: Creation of directory " + path + " failed, check does Android Manifest have permission to write to external storage."));
        }
    }

    private static void copyTessDataFiles(Context context) {
        try {
            String[] fileList;
            for (String fileName : fileList = context.getAssets().list(TESSDATA)) {
                int len;
                String pathToDataFile = DATA_PATH + TESSDATA + "/" + fileName;
                InputStream in = context.getAssets().open("tessdata/" + fileName);
                FileOutputStream out = new FileOutputStream(pathToDataFile, false);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Unable to copy files to tessdata " + e.toString()));
        }
    }

    static Point getBestFitSize(Size[] sizes, float screenAR) {
        Size bestFit = null;
        int difference = Integer.MAX_VALUE;
        for (Size s : sizes) {
            int biggerSide = Math.max(s.getWidth(), s.getHeight());
            int currentDiff = Math.abs(biggerSide - 1920);
            if (currentDiff < difference) {
                difference = currentDiff;
                bestFit = s;
                continue;
            }
            if (currentDiff != difference) continue;
            float currentSmallAR = (float)Math.max(s.getWidth(), s.getHeight()) / (float)Math.min(s.getWidth(), s.getHeight());
            float bfSmallAR = (float)Math.max(bestFit.getWidth(), bestFit.getHeight()) / (float)Math.min(bestFit.getWidth(), bestFit.getHeight());
            if (!(Math.abs(currentSmallAR - screenAR) < Math.abs(bfSmallAR - screenAR))) continue;
            bestFit = s;
        }
        return new Point(bestFit.getWidth(), bestFit.getHeight());
    }

    Mat rotateMat(Mat mat, Context context, int sensorOrientation) {
        int rotation = ((Activity)context).getWindowManager().getDefaultDisplay().getRotation();
        int orientation = this.getOrientation(rotation, sensorOrientation);
        if (orientation == 180 || orientation == -180) {
            Core.flip(mat, mat, -1);
        } else if (orientation == 90 || orientation == -270) {
            Core.flip(mat.t(), mat, 1);
        } else if (orientation == 270 || orientation == -90) {
            Core.flip(mat.t(), mat, 0);
        }
        return mat;
    }

    private int getOrientation(int rotation, int sensorOrientation) {
        return (ORIENTATIONS.get(rotation) + sensorOrientation + 270) % 360;
    }

    private static boolean isScannerTypeDoc() {
        return scannerType == ScannerType.SCANNER_TYPE_DOC_IMAGE_ID || scannerType == ScannerType.SCANNER_TYPE_DOC_IMAGE_PASSPORT;
    }

    static {
        System.loadLibrary("native-lib");
        ORIENTATIONS = new SparseIntArray();
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
        isIDActive = false;
        isPassportActive = false;
        isVisaActive = false;
        scanningState = 1;
        scannerType = ScannerType.SCANNER_TYPE_MRZ;
        DATA_PATH = Environment.getExternalStorageDirectory().toString() + "/TesseractFiles/";
        activeThreads = 0;
        AVAILABLE_THREADS = Runtime.getRuntime().availableProcessors();
        maxThreads = Math.min(2, AVAILABLE_THREADS);
    }
}

