/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.hardware.Camera;
import android.util.Log;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

final class CameraConfigurationUtils {
    private static final String TAG = "CameraConfiguration";

    private CameraConfigurationUtils() {
    }

    public static void setTorch(Camera.Parameters parameters, boolean on) {
        List supportedFlashModes = parameters.getSupportedFlashModes();
        String flashMode = on ? CameraConfigurationUtils.findSettableValue("flash mode", supportedFlashModes, "torch", "on") : CameraConfigurationUtils.findSettableValue("flash mode", supportedFlashModes, "off");
        if (flashMode != null) {
            if (flashMode.equals(parameters.getFlashMode())) {
                Log.i((String)TAG, (String)("Flash mode already set to " + flashMode));
            } else {
                Log.i((String)TAG, (String)("Setting flash mode to " + flashMode));
                parameters.setFlashMode(flashMode);
            }
        }
    }

    private static String findSettableValue(String name, Collection<String> supportedValues, String ... desiredValues) {
        Log.i((String)TAG, (String)("Requesting " + name + " value from among: " + Arrays.toString(desiredValues)));
        Log.i((String)TAG, (String)("Supported " + name + " values: " + supportedValues));
        if (supportedValues != null) {
            for (String desiredValue : desiredValues) {
                if (!supportedValues.contains(desiredValue)) continue;
                Log.i((String)TAG, (String)("Can set " + name + " to: " + desiredValue));
                return desiredValue;
            }
        }
        Log.i((String)TAG, (String)"No supported values match");
        return null;
    }
}

