/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.hardware.Camera;
import android.preference.PreferenceManager;
import android.util.Log;
import android.util.Size;
import android.view.Display;
import android.view.WindowManager;
import com.scansolutions.mrzscannerlib.CameraConfigurationUtils;
import com.scansolutions.mrzscannerlib.MRZCore;
import com.scansolutions.mrzscannerlib.open.CameraFacing;
import com.scansolutions.mrzscannerlib.open.OpenCamera;
import java.util.List;

final class CameraConfigurationManager {
    private static final String TAG = "CameraConfiguration";
    private final Context context;
    private int cwNeededRotation;
    private int cwRotationFromDisplayToCamera;
    private Point screenResolution;
    private Point cameraResolution;
    private Point bestPreviewSize;
    private Point previewSizeOnScreen;

    CameraConfigurationManager(Context context) {
        this.context = context;
    }

    void initFromCameraParameters(OpenCamera camera) {
        int cwRotationFromNaturalToDisplay;
        Camera.Parameters parameters = camera.getCamera().getParameters();
        WindowManager manager = (WindowManager)this.context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        int displayRotation = display.getRotation();
        switch (displayRotation) {
            case 0: {
                cwRotationFromNaturalToDisplay = 0;
                break;
            }
            case 1: {
                cwRotationFromNaturalToDisplay = 90;
                break;
            }
            case 2: {
                cwRotationFromNaturalToDisplay = 180;
                break;
            }
            case 3: {
                cwRotationFromNaturalToDisplay = 270;
                break;
            }
            default: {
                if (displayRotation % 90 == 0) {
                    cwRotationFromNaturalToDisplay = (360 + displayRotation) % 360;
                    break;
                }
                throw new IllegalArgumentException("Bad rotation: " + displayRotation);
            }
        }
        Log.i((String)TAG, (String)("Display at: " + cwRotationFromNaturalToDisplay));
        int cwRotationFromNaturalToCamera = camera.getOrientation();
        Log.i((String)TAG, (String)("Camera at: " + cwRotationFromNaturalToCamera));
        if (camera.getFacing() == CameraFacing.FRONT) {
            cwRotationFromNaturalToCamera = (360 - cwRotationFromNaturalToCamera) % 360;
            Log.i((String)TAG, (String)("Front camera overriden to: " + cwRotationFromNaturalToCamera));
        }
        this.cwRotationFromDisplayToCamera = (360 + cwRotationFromNaturalToCamera - cwRotationFromNaturalToDisplay) % 360;
        Log.i((String)TAG, (String)("Final display orientation: " + this.cwRotationFromDisplayToCamera));
        if (camera.getFacing() == CameraFacing.FRONT) {
            Log.i((String)TAG, (String)"Compensating rotation for front camera");
            this.cwNeededRotation = (360 - this.cwRotationFromDisplayToCamera) % 360;
        } else {
            this.cwNeededRotation = this.cwRotationFromDisplayToCamera;
        }
        Log.i((String)TAG, (String)("Clockwise rotation from display to camera: " + this.cwNeededRotation));
        Point theScreenResolution = new Point();
        display.getSize(theScreenResolution);
        this.screenResolution = theScreenResolution;
        Log.i((String)TAG, (String)("Screen resolution in current orientation: " + this.screenResolution));
        List previewSizes = parameters.getSupportedPreviewSizes();
        Size[] sizes = new Size[previewSizes.size()];
        for (int i = 0; i < previewSizes.size(); ++i) {
            sizes[i] = new Size(((Camera.Size)previewSizes.get((int)i)).width, ((Camera.Size)previewSizes.get((int)i)).height);
        }
        this.cameraResolution = MRZCore.getBestFitSize(sizes, (float)Math.max(display.getWidth(), display.getHeight()) / (float)Math.min(display.getWidth(), display.getHeight()));
        Log.i((String)TAG, (String)("Camera resolution: " + this.cameraResolution));
        this.bestPreviewSize = MRZCore.getBestFitSize(sizes, (float)Math.max(display.getWidth(), display.getHeight()) / (float)Math.min(display.getWidth(), display.getHeight()));
        Log.i((String)TAG, (String)("Best available preview size: " + this.bestPreviewSize));
        boolean isScreenPortrait = this.screenResolution.x < this.screenResolution.y;
        boolean isPreviewSizePortrait = this.bestPreviewSize.x < this.bestPreviewSize.y;
        this.previewSizeOnScreen = isScreenPortrait == isPreviewSizePortrait ? this.bestPreviewSize : new Point(this.bestPreviewSize.y, this.bestPreviewSize.x);
        Log.i((String)TAG, (String)("Preview size on screen: " + this.previewSizeOnScreen));
    }

    void setDesiredCameraParameters(OpenCamera camera, boolean safeMode) {
        Camera theCamera = camera.getCamera();
        Camera.Parameters parameters = theCamera.getParameters();
        if (parameters == null) {
            Log.w((String)TAG, (String)"Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        Log.i((String)TAG, (String)("Initial camera parameters: " + parameters.flatten()));
        if (safeMode) {
            Log.w((String)TAG, (String)"In camera config safe mode -- most settings will not be honored");
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        this.initializeTorch(parameters, prefs, safeMode);
        parameters.setPreviewSize(this.bestPreviewSize.x, this.bestPreviewSize.y);
        theCamera.setParameters(parameters);
        theCamera.setDisplayOrientation(this.cwRotationFromDisplayToCamera);
        Camera.Parameters afterParameters = theCamera.getParameters();
        Camera.Size afterSize = afterParameters.getPreviewSize();
        if (afterSize != null && (this.bestPreviewSize.x != afterSize.width || this.bestPreviewSize.y != afterSize.height)) {
            Log.w((String)TAG, (String)("Camera said it supported preview size " + this.bestPreviewSize.x + 'x' + this.bestPreviewSize.y + ", but after setting it, preview size is " + afterSize.width + 'x' + afterSize.height));
            this.bestPreviewSize.x = afterSize.width;
            this.bestPreviewSize.y = afterSize.height;
        }
    }

    Point getBestPreviewSize() {
        return this.bestPreviewSize;
    }

    Point getPreviewSizeOnScreen() {
        return this.previewSizeOnScreen;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    int getCWNeededRotation() {
        return this.cwNeededRotation;
    }

    boolean getTorchState(Camera camera) {
        Camera.Parameters parameters;
        if (camera != null && (parameters = camera.getParameters()) != null) {
            String flashMode = parameters.getFlashMode();
            return "on".equals(flashMode) || "torch".equals(flashMode);
        }
        return false;
    }

    void setTorch(Camera camera, boolean newSetting) {
        Camera.Parameters parameters = camera.getParameters();
        this.doSetTorch(parameters, newSetting);
        camera.setParameters(parameters);
    }

    private void initializeTorch(Camera.Parameters parameters, SharedPreferences prefs, boolean safeMode) {
        this.doSetTorch(parameters, false);
    }

    private void doSetTorch(Camera.Parameters parameters, boolean newSetting) {
        CameraConfigurationUtils.setTorch(parameters, newSetting);
    }
}

