/*
 * Decompiled with CFR 0.152.
 */
package com.scansolutions.mrzscannerlib;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.support.annotation.NonNull;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import com.scansolutions.mrzscannerlib.AutoFitTextureView;
import com.scansolutions.mrzscannerlib.ImageUtils;
import com.scansolutions.mrzscannerlib.MRZCore;
import com.scansolutions.mrzscannerlib.MRZOverlay;
import com.scansolutions.mrzscannerlib.MRZScanner;
import com.scansolutions.mrzscannerlib.MRZScannerListener;
import com.scansolutions.mrzscannerlib.R;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.opencv.core.Mat;

class Camera2Impl {
    private static final String TAG = Camera2Impl.class.getSimpleName();
    private CameraCaptureSession mCaptureSession;
    private CameraDevice mCameraDevice;
    private Size mPreviewSize;
    private ImageReader mImageReader;
    private CaptureRequest.Builder mPreviewRequestBuilder;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private boolean mFlashSupported;
    private static boolean isCameraAdjustingFocus = false;
    private Context mContext;
    private String mCameraId;
    private MRZCore mrzCore;
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    private int mSensorOrientation;
    private CameraInitListener cameraInitListener;
    private AutoFitTextureView mTextureView;
    private ImageButton btnFlash;
    private CaptureRequest mPreviewRequest;
    final TextureView.SurfaceTextureListener mSurfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture texture, int width, int height) {
            Camera2Impl.this.openCamera2(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture texture, int width, int height) {
            Camera2Impl.this.configureTransform(width, height);
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture texture) {
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture texture) {
        }
    };
    private final CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice cameraDevice) {
            Camera2Impl.this.mCameraOpenCloseLock.release();
            Camera2Impl.this.mCameraDevice = cameraDevice;
            Camera2Impl.this.createCamera2PreviewSession();
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            Camera2Impl.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            Camera2Impl.this.mCameraDevice = null;
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            Camera2Impl.this.mCameraOpenCloseLock.release();
            cameraDevice.close();
            Camera2Impl.this.mCameraDevice = null;
        }
    };
    private final ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            final Image img = reader.acquireLatestImage();
            if (MRZCore.activeThreads >= MRZCore.maxThreads || MRZCore.scanningState == 1 || isCameraAdjustingFocus || img == null) {
                if (img != null) {
                    img.close();
                }
                return;
            }
            ++MRZCore.activeThreads;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Mat imageGrab = ImageUtils.imageToMat(img);
                    img.close();
                    imageGrab = Camera2Impl.this.mrzCore.rotateMat(imageGrab, Camera2Impl.this.mContext, Camera2Impl.this.mSensorOrientation);
                    Camera2Impl.this.mrzCore.scan(imageGrab);
                    --MRZCore.activeThreads;
                }
            }).start();
        }
    };
    private CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult result) {
            Integer afState;
            if (MRZCore.scanningState == 0 && (afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE)) != null) {
                isCameraAdjustingFocus = 2 != afState && 4 != afState && 6 != afState && 0 != afState;
            }
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };

    Camera2Impl(Context context, MRZScannerListener scannerListener, AutoFitTextureView mTextureView, ImageButton btnFlash, CameraInitListener cameraInitListener, MRZOverlay mrzOverlay, ImageView debugPreview) {
        this.mContext = context;
        this.mrzCore = new MRZCore(mrzOverlay, debugPreview, scannerListener);
        this.mTextureView = mTextureView;
        this.btnFlash = btnFlash;
        this.cameraInitListener = cameraInitListener;
    }

    private static Size chooseOptimalSize(Size[] choices, int textureViewWidth, int textureViewHeight, int maxWidth, int maxHeight, Size aspectRatio) {
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        ArrayList<Size> notBigEnough = new ArrayList<Size>();
        int w = aspectRatio.getWidth();
        int h = aspectRatio.getHeight();
        for (Size option : choices) {
            if (option.getWidth() > maxWidth || option.getHeight() > maxHeight || option.getHeight() != option.getWidth() * h / w) continue;
            if (option.getWidth() >= textureViewWidth && option.getHeight() >= textureViewHeight) {
                bigEnough.add(option);
                continue;
            }
            notBigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            return Collections.min(bigEnough, new CompareSizesByArea());
        }
        if (notBigEnough.size() > 0) {
            return Collections.max(notBigEnough, new CompareSizesByArea());
        }
        Log.e((String)TAG, (String)"Couldn't find any suitable preview size");
        return choices[0];
    }

    private boolean setUpCameraOutputs(int width, int height) throws NullPointerException {
        boolean afSupported = false;
        boolean resSupported = false;
        CameraManager manager = (CameraManager)this.mContext.getSystemService("camera");
        try {
            for (String cameraId : manager.getCameraIdList()) {
                int[] afModes;
                StreamConfigurationMap map;
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
                Integer facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (facing != null && facing == 0 || (map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)) == null) continue;
                Point displaySize = new Point();
                ((Activity)this.mContext).getWindowManager().getDefaultDisplay().getSize(displaySize);
                int rotatedPreviewWidth = width;
                int rotatedPreviewHeight = height;
                int maxPreviewWidth = displaySize.x;
                int maxPreviewHeight = displaySize.y;
                Size[] sizes = map.getOutputSizes(35);
                Point bestFit = MRZCore.getBestFitSize(sizes, (float)Math.max(maxPreviewWidth, maxPreviewHeight) / (float)Math.min(maxPreviewWidth, maxPreviewHeight));
                for (Size size : sizes) {
                    if (size.getWidth() * size.getHeight() <= 4500000) continue;
                    resSupported = true;
                    break;
                }
                if ((afModes = (int[])characteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) != null && afModes.length > 1) {
                    afSupported = true;
                }
                this.mImageReader = ImageReader.newInstance((int)bestFit.x, (int)bestFit.y, (int)35, (int)(MRZCore.maxThreads + 2));
                this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, null);
                int displayRotation = ((Activity)this.mContext).getWindowManager().getDefaultDisplay().getRotation();
                this.mSensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                boolean swappedDimensions = false;
                switch (displayRotation) {
                    case 0: 
                    case 2: {
                        if (this.mSensorOrientation != 90 && this.mSensorOrientation != 270) break;
                        swappedDimensions = true;
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (this.mSensorOrientation != 0 && this.mSensorOrientation != 180) break;
                        swappedDimensions = true;
                        break;
                    }
                    default: {
                        Log.e((String)TAG, (String)("Display rotation is invalid: " + displayRotation));
                    }
                }
                if (swappedDimensions) {
                    rotatedPreviewWidth = height;
                    rotatedPreviewHeight = width;
                    maxPreviewWidth = displaySize.y;
                    maxPreviewHeight = displaySize.x;
                }
                if (maxPreviewWidth > 1920) {
                    maxPreviewWidth = 1920;
                }
                if (maxPreviewHeight > 1080) {
                    maxPreviewHeight = 1080;
                }
                this.mPreviewSize = Camera2Impl.chooseOptimalSize(map.getOutputSizes(SurfaceTexture.class), rotatedPreviewWidth, rotatedPreviewHeight, maxPreviewWidth, maxPreviewHeight, new Size(bestFit.x, bestFit.y));
                Boolean available = (Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
                this.mFlashSupported = available == null ? false : available;
                this.mCameraId = cameraId;
                if (!this.mFlashSupported) continue;
                this.btnFlash.setVisibility(0);
                this.btnFlash.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Camera2Impl.this.switchFlash();
                    }
                });
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        return afSupported && resSupported;
    }

    @SuppressLint(value={"MissingPermission"})
    void openCamera2(int width, int height) {
        if (!MRZScanner.hasPermissions(this.mContext, "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA")) {
            this.cameraInitListener.shouldRequestCameraPermission();
            return;
        }
        boolean doesCameraMeetRequirements = this.setUpCameraOutputs(width, height);
        this.configureTransform(width, height);
        CameraManager manager = (CameraManager)this.mContext.getSystemService("camera");
        try {
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            manager.openCamera(this.mCameraId, this.mStateCallback, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", e);
        }
        if (!doesCameraMeetRequirements) {
            this.cameraInitListener.warnIncompatibleCamera();
        }
    }

    void closeCamera2() {
        try {
            this.mCameraOpenCloseLock.acquire();
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
            if (null != this.mImageReader) {
                this.mImageReader.close();
                this.mImageReader = null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.mCameraOpenCloseLock.release();
        }
    }

    private void createCamera2PreviewSession() {
        try {
            SurfaceTexture texture = this.mTextureView.getSurfaceTexture();
            assert (texture != null);
            texture.setDefaultBufferSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
            Surface surface = new Surface(texture);
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(1);
            this.mPreviewRequestBuilder.addTarget(surface);
            this.mPreviewRequestBuilder.addTarget(this.mImageReader.getSurface());
            this.mCameraDevice.createCaptureSession(Arrays.asList(surface, this.mImageReader.getSurface()), new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    if (null == Camera2Impl.this.mCameraDevice) {
                        return;
                    }
                    Camera2Impl.this.mCaptureSession = cameraCaptureSession;
                    try {
                        Camera2Impl.this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        Camera2Impl.this.mPreviewRequest = Camera2Impl.this.mPreviewRequestBuilder.build();
                        Camera2Impl.this.mCaptureSession.setRepeatingRequest(Camera2Impl.this.mPreviewRequest, Camera2Impl.this.mCaptureCallback, null);
                        MRZCore.scanningState = 0;
                    }
                    catch (CameraAccessException e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    Log.i((String)TAG, (String)"onConfigureFailed");
                }
            }, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void configureTransform(int viewWidth, int viewHeight) {
        if (null == this.mTextureView || null == this.mPreviewSize) {
            return;
        }
        int rotation = ((Activity)this.mContext).getWindowManager().getDefaultDisplay().getRotation();
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.mPreviewSize.getHeight(), (float)this.mPreviewSize.getWidth());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        if (1 == rotation || 3 == rotation) {
            bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
            matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
            float scale = Math.max((float)viewHeight / (float)this.mPreviewSize.getHeight(), (float)viewWidth / (float)this.mPreviewSize.getWidth());
            matrix.postScale(scale, scale, centerX, centerY);
            matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
        } else if (2 == rotation) {
            matrix.postRotate(180.0f, centerX, centerY);
        }
        this.mTextureView.setTransform(matrix);
    }

    private void switchFlash() {
        if (this.mFlashSupported && this.mCaptureSession != null) {
            try {
                boolean bl = this.mrzCore.isTorchOn = !this.mrzCore.isTorchOn;
                if (this.mrzCore.isTorchOn) {
                    this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)2);
                    this.btnFlash.setImageResource(R.drawable.amrz_ic_flash_on);
                } else {
                    this.mPreviewRequestBuilder.set(CaptureRequest.FLASH_MODE, (Object)0);
                    this.btnFlash.setImageResource(R.drawable.amrz_ic_ico_flash_off);
                }
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), this.mCaptureCallback, null);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
        }
    }

    static class CompareSizesByArea
    implements Comparator<Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }

    static interface CameraInitListener {
        public void shouldRequestCameraPermission();

        public void warnIncompatibleCamera();
    }
}

