/*
 * Decompiled with CFR 0.152.
 */
package com.sayagodshala.authui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TextInputLayout;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.sayagodshala.authui.AuthUISettings;
import com.sayagodshala.authui.MaterialColor;
import com.sayagodshala.authui.MaterialTheme;
import com.sayagodshala.authui.R;

public class AuthUIFragment
extends Fragment
implements View.OnClickListener {
    public static final String TAG = "AuthUIFragment";
    public static String AUTHUI_SETTINGS = "authui_settings";
    private Bundle bundle;
    private AuthUIFragmentListener mListener;
    ImageView bg;
    ImageView appLogo;
    TextView title;
    TextInputLayout layoutName;
    EditText name;
    TextInputLayout layoutEmail;
    EditText email;
    TextInputLayout layoutMobile;
    EditText mobile;
    TextInputLayout layoutPassword;
    EditText password;
    Button proceed;
    TextView forgotPassword;
    LinearLayout orCont;
    LinearLayout socials;
    LinearLayout belowCont;
    RelativeLayout fb;
    RelativeLayout google;
    TextView terms;
    TextView signinSignup;
    TextView facebookTv;
    TextView googleTv;
    TextView or;
    View socialDivider;
    private View view;
    private AuthUISettings authUISettings;

    public static AuthUIFragment newInstance(AuthUISettings authUISettings) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(AUTHUI_SETTINGS, (Parcelable)authUISettings);
        AuthUIFragment fragment = new AuthUIFragment();
        if (bundle != null) {
            fragment.setArguments(bundle);
        }
        return fragment;
    }

    public static void loadFragment(FragmentActivity activity, Fragment f, int frameId) {
        activity.getSupportFragmentManager().beginTransaction().add(frameId, f, TAG).addToBackStack(TAG).commitAllowingStateLoss();
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.fragment_auth, container, false);
        this.bundle = this.getArguments();
        if (this.bundle != null && this.bundle.containsKey(AUTHUI_SETTINGS)) {
            this.authUISettings = (AuthUISettings)this.bundle.getParcelable(AUTHUI_SETTINGS);
            Log.d((String)"AuthUISettings", (String)new Gson().toJson((Object)this.authUISettings));
            this.bindView(this.view);
            this.setClickListener();
            this.bindData();
        } else {
            this.getActivity().getFragmentManager().popBackStack();
        }
        return this.view;
    }

    public void onButtonPressed(Uri uri) {
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof AuthUIFragmentListener)) {
            throw new RuntimeException(context.toString() + " must implement AuthUIFragmentListener");
        }
        this.mListener = (AuthUIFragmentListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.proceed) {
            if (this.layoutName.getVisibility() == 0) {
                if (this.isSignUpValid() && this.mListener != null) {
                    this.mListener.onSignupClicked(this.name.getText().toString(), this.email.getText().toString(), this.mobile.getText().toString(), this.password.getText().toString());
                }
            } else if (!this.proceed.getText().toString().equalsIgnoreCase("Login")) {
                if (this.isSignInValid() && this.mListener != null) {
                    this.mListener.onLoginClicked(this.email.getText().toString(), this.password.getText().toString());
                }
            } else if (this.isForgotPasswordValid() && this.mListener != null) {
                this.mListener.onForgotPasswordClicked(this.email.getText().toString());
            }
        } else if (view.getId() == R.id.fb) {
            if (this.mListener != null) {
                this.mListener.onFacebookClicked(this.layoutName.getVisibility() == 0);
            }
        } else if (view.getId() == R.id.google) {
            if (this.mListener != null) {
                this.mListener.onGoogleClicked(this.layoutName.getVisibility() == 0);
            }
        } else if (view.getId() == R.id.signin_signup) {
            if (!this.authUISettings.isSignupRequired()) {
                return;
            }
            if (this.layoutName.getVisibility() == 0) {
                this.setLoginView();
            } else {
                this.setSignupView();
            }
        } else if (view.getId() == R.id.forgot_password) {
            this.setForgotPasswordView();
        }
    }

    private void bindView(View view) {
        this.bg = (ImageView)view.findViewById(R.id.bg);
        this.appLogo = (ImageView)view.findViewById(R.id.app_logo);
        this.title = (TextView)view.findViewById(R.id.title);
        this.layoutName = (TextInputLayout)view.findViewById(R.id.layout_name);
        this.name = (EditText)view.findViewById(R.id.name);
        this.layoutEmail = (TextInputLayout)view.findViewById(R.id.layout_email);
        this.email = (EditText)view.findViewById(R.id.email);
        this.layoutMobile = (TextInputLayout)view.findViewById(R.id.layout_mobile);
        this.mobile = (EditText)view.findViewById(R.id.mobile);
        this.layoutPassword = (TextInputLayout)view.findViewById(R.id.layout_password);
        this.password = (EditText)view.findViewById(R.id.password);
        this.proceed = (Button)view.findViewById(R.id.proceed);
        this.orCont = (LinearLayout)view.findViewById(R.id.or_cont);
        this.forgotPassword = (TextView)view.findViewById(R.id.forgot_password);
        this.socials = (LinearLayout)view.findViewById(R.id.socials);
        this.fb = (RelativeLayout)view.findViewById(R.id.fb);
        this.google = (RelativeLayout)view.findViewById(R.id.google);
        this.terms = (TextView)view.findViewById(R.id.terms);
        this.signinSignup = (TextView)view.findViewById(R.id.signin_signup);
        this.facebookTv = (TextView)view.findViewById(R.id.facebook_tv);
        this.googleTv = (TextView)view.findViewById(R.id.google_tv);
        this.or = (TextView)view.findViewById(R.id.or);
        this.socialDivider = view.findViewById(R.id.social_divider);
        this.belowCont = (LinearLayout)view.findViewById(R.id.below_cont);
    }

    private void setClickListener() {
        this.signinSignup.setOnClickListener((View.OnClickListener)this);
        this.proceed.setOnClickListener((View.OnClickListener)this);
        this.google.setOnClickListener((View.OnClickListener)this);
        this.fb.setOnClickListener((View.OnClickListener)this);
        this.forgotPassword.setOnClickListener((View.OnClickListener)this);
    }

    private void bindData() {
        if (this.bundle != null && this.authUISettings != null) {
            if (!this.authUISettings.isFacebookLoginRequired() && !this.authUISettings.isGoogleLoginRequired()) {
                this.authUISettings.setSocialPlatformRequired(false);
            }
            if (!this.authUISettings.isSocialPlatformRequired()) {
                this.socials.setVisibility(8);
                this.orCont.setVisibility(8);
            }
            if (!this.authUISettings.isFacebookLoginRequired()) {
                this.socialDivider.setVisibility(8);
                this.fb.setVisibility(8);
            }
            if (!this.authUISettings.isGoogleLoginRequired()) {
                this.socialDivider.setVisibility(8);
                this.google.setVisibility(8);
            }
            if (!this.authUISettings.isAppLogoRequired()) {
                this.appLogo.setVisibility(0);
            } else if (this.authUISettings.getAppLogo() != 0) {
                this.appLogo.setImageResource(this.authUISettings.getAppLogo());
            }
            if (!this.authUISettings.isSignupRequired()) {
                this.signinSignup.setVisibility(8);
            }
            switch (this.authUISettings.getDefaultView()) {
                case LOGIN: {
                    this.setLoginView();
                    break;
                }
                case SIGNUP: {
                    this.setSignupView();
                    break;
                }
                default: {
                    this.setForgotPasswordView();
                }
            }
            this.applyTheme();
        }
    }

    private void setLoginView() {
        if (this.authUISettings != null) {
            this.layoutName.setVisibility(8);
            this.layoutMobile.setVisibility(8);
            if (!this.authUISettings.isForgotPasswordRequired()) {
                this.forgotPassword.setVisibility(8);
            } else {
                this.forgotPassword.setVisibility(0);
            }
            this.belowCont.setVisibility(0);
            this.title.setText((CharSequence)this.authUISettings.getLoginTitle());
            this.terms.setText((CharSequence)this.authUISettings.getLoginTerms());
            if (this.authUISettings.isSocialPlatformRequired()) {
                this.facebookTv.setText((CharSequence)this.authUISettings.getFacebookLoginTitle());
                this.googleTv.setText((CharSequence)this.authUISettings.getGoogleLoginTitle());
            }
            if (this.authUISettings.isSignupRequired()) {
                this.signinSignup.setText((CharSequence)this.authUISettings.getSignupToggleTitle());
            }
            this.proceed.setText((CharSequence)this.getString(R.string.loggin));
        }
    }

    private void setSignupView() {
        if (this.authUISettings != null) {
            this.layoutName.setVisibility(0);
            this.layoutMobile.setVisibility(0);
            this.forgotPassword.setVisibility(8);
            this.title.setText((CharSequence)this.authUISettings.getSignupTitle());
            this.terms.setText((CharSequence)this.authUISettings.getSignupTerms());
            this.belowCont.setVisibility(0);
            if (this.authUISettings.isSocialPlatformRequired()) {
                this.facebookTv.setText((CharSequence)this.authUISettings.getFacebookSignupTitle());
                this.googleTv.setText((CharSequence)this.authUISettings.getGoogleSignupTitle());
            }
            if (this.authUISettings.isSignupRequired()) {
                this.signinSignup.setText((CharSequence)this.authUISettings.getLoginToggleTitle());
            }
            this.proceed.setText((CharSequence)this.getString(R.string.signup));
        }
    }

    private void setForgotPasswordView() {
        if (this.authUISettings != null) {
            this.layoutName.setVisibility(8);
            this.layoutMobile.setVisibility(8);
            this.layoutEmail.setVisibility(0);
            this.layoutPassword.setVisibility(8);
            this.title.setText((CharSequence)this.authUISettings.getForgotPasswordTitle());
            this.belowCont.setVisibility(8);
            this.signinSignup.setVisibility(8);
            this.proceed.setText((CharSequence)this.getString(R.string.submit));
        }
    }

    private boolean isSignInValid() {
        String validationMessage = "";
        String emailStr = this.email.getText().toString().trim();
        if (!AuthUIFragment.isValidEmail(emailStr)) {
            this.email.requestFocus();
            validationMessage = "Please enter valid email";
        } else if (AuthUIFragment.textIsEmpty(this.password.getText().toString())) {
            this.password.requestFocus();
            validationMessage = "Invalid Password";
        }
        if (validationMessage.length() != 0) {
            this.showSnackBar(validationMessage);
        }
        return validationMessage.length() == 0;
    }

    private boolean isSignUpValid() {
        String validationMessage = "";
        String nameStr = this.name.getText().toString().trim();
        String emailStr = this.email.getText().toString().trim();
        String mobileStr = this.mobile.getText().toString().trim();
        String passwordStr = this.password.getText().toString().trim();
        if (AuthUIFragment.textIsEmpty(nameStr)) {
            this.name.requestFocus();
            validationMessage = "Please enter name";
        } else if (!AuthUIFragment.isValidEmail(emailStr)) {
            this.email.requestFocus();
            validationMessage = "Please enter valid email";
        } else if (AuthUIFragment.textIsEmpty(mobileStr)) {
            this.mobile.requestFocus();
            validationMessage = "Please enter mobile";
        } else if (AuthUIFragment.textIsEmpty(passwordStr)) {
            this.mobile.requestFocus();
            validationMessage = "Please enter password";
        }
        if (validationMessage.length() != 0) {
            this.showSnackBar(validationMessage);
        }
        return validationMessage.length() == 0;
    }

    private boolean isForgotPasswordValid() {
        String validationMessage = "";
        String emailStr = this.email.getText().toString().trim();
        if (!AuthUIFragment.isValidEmail(emailStr)) {
            this.email.requestFocus();
            validationMessage = "Please enter valid email";
        }
        if (validationMessage.length() != 0) {
            this.showSnackBar(validationMessage);
        }
        return validationMessage.length() == 0;
    }

    public static boolean textIsEmpty(String value) {
        boolean isWhitespace;
        if (value == null) {
            return true;
        }
        boolean empty = false;
        String message = value.trim();
        if (TextUtils.isEmpty((CharSequence)message)) {
            empty = true;
        }
        if (isWhitespace = message.matches("^\\s*$")) {
            empty = true;
        }
        return empty;
    }

    public static final boolean isValidEmail(CharSequence target) {
        if (target == null) {
            return false;
        }
        return Patterns.EMAIL_ADDRESS.matcher(target).matches();
    }

    public void showSnackBar(String message) {
        Snackbar snackbar = Snackbar.make((View)this.getActivity().findViewById(0x1020002), (CharSequence)message, (int)0);
        snackbar.show();
    }

    public static StateListDrawable selectorBackgroundColor(int normal, int pressed) {
        GradientDrawable normalDrawable = new GradientDrawable();
        normalDrawable.setColor(normal);
        normalDrawable.setCornerRadius(8.0f);
        GradientDrawable pressedDrawable = new GradientDrawable();
        pressedDrawable.setColor(pressed);
        pressedDrawable.setCornerRadius(8.0f);
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, (Drawable)pressedDrawable);
        states.addState(new int[0], (Drawable)normalDrawable);
        return states;
    }

    private void applyTheme() {
        if (this.authUISettings != null) {
            MaterialTheme materialTheme = this.authUISettings.getMaterialTheme();
            MaterialColor materialColor = materialTheme.getColor();
            if (this.authUISettings.getBg() != 0) {
                this.bg.setImageResource(this.authUISettings.getBg());
            } else {
                this.bg.setBackgroundColor(this.getResources().getColor(materialColor.getRegular()));
            }
            this.appLogo.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.title.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.forgotPassword.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.terms.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.proceed.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.email.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.mobile.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.name.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.password.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.or.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.proceed.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            this.proceed.setBackgroundDrawable((Drawable)AuthUIFragment.selectorBackgroundColor(this.getResources().getColor(materialColor.getLight()), this.getResources().getColor(materialColor.getDark())));
            if (materialTheme.equals((Object)MaterialTheme.INDIGO)) {
                this.fb.setBackgroundDrawable((Drawable)AuthUIFragment.selectorBackgroundColor(this.getResources().getColor(materialColor.getLight()), this.getResources().getColor(materialColor.getDark())));
            } else if (materialTheme.equals((Object)MaterialTheme.PINK)) {
                this.google.setBackgroundDrawable((Drawable)AuthUIFragment.selectorBackgroundColor(this.getResources().getColor(materialColor.getLight()), this.getResources().getColor(materialColor.getDark())));
            } else if (materialTheme.equals((Object)MaterialTheme.RED)) {
                this.google.setBackgroundDrawable((Drawable)AuthUIFragment.selectorBackgroundColor(this.getResources().getColor(materialColor.getLight()), this.getResources().getColor(materialColor.getDark())));
            }
            this.signinSignup.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getTextPrimaryColor()));
            if (Build.VERSION.SDK_INT >= 21) {
                Window window = this.getActivity().getWindow();
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(ContextCompat.getColor((Context)this.getContext(), (int)materialColor.getRegular()));
            }
        }
    }

    public static interface AuthUIFragmentListener {
        public void onLoginClicked(String var1, String var2);

        public void onSignupClicked(String var1, String var2, String var3, String var4);

        public void onForgotPasswordClicked(String var1);

        public void onFacebookClicked(boolean var1);

        public void onGoogleClicked(boolean var1);
    }
}

