/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.security;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.commons.codec.binary.Base64;

public class AuthJWTToken {
    private JsonObject jwtJson;
    private String jwtStr;

    public AuthJWTToken(String base64EncodedJWTStr) {
        String[] splitString = base64EncodedJWTStr.split("\\.");
        String base64EncodedBody = null;
        if (splitString.length == 3) {
            base64EncodedBody = splitString[1];
        }
        if (base64EncodedBody != null && !"".equals(base64EncodedBody)) {
            Base64 base64Url = new Base64(true);
            String jwtInfo = new String(base64Url.decode(base64EncodedBody));
            JsonParser jsonParser = new JsonParser();
            this.jwtJson = (JsonObject)jsonParser.parse(jwtInfo);
            this.jwtStr = base64EncodedJWTStr;
        }
    }

    public AuthJWTToken(String jwtToken, JsonObject jwtJson) {
        this.jwtStr = jwtToken;
        this.jwtJson = jwtJson;
    }

    public JsonObject getJwtAsJsonNode() {
        return this.jwtJson;
    }

    public String getJwtAsBase64String() {
        return this.jwtStr;
    }
}

