/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.response.impl;

import com.sap.cloud.sdk.service.prov.api.response.UpdateResponse;
import com.sap.cloud.sdk.service.prov.api.response.UpdateResponseBuilder;
import com.sap.cloud.sdk.service.prov.api.response.impl.UpdateResponseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateResponseBuilderImpl
implements UpdateResponseBuilder {
    private static Logger log = LoggerFactory.getLogger(UpdateResponseBuilderImpl.class);
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private boolean enable = false;

    @Override
    public UpdateResponseBuilder addHeaders(Map<String, List<String>> headers) {
        if (headers != null && !headers.isEmpty()) {
            if (this.headers.isEmpty()) {
                this.headers.putAll(headers);
            } else {
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                    String headerName = this.getHeaderName(entry.getKey());
                    if (this.headers.get(headerName) == null) {
                        this.headers.put(headerName, new ArrayList(entry.getValue()));
                        continue;
                    }
                    this.headers.get(headerName).addAll((Collection<String>)entry.getValue());
                }
            }
        }
        return this;
    }

    @Override
    public UpdateResponseBuilder setHeader(String name, String value) {
        String headerName = this.getHeaderName(name);
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(value);
        if (log.isDebugEnabled()) {
            log.debug("Set header name " + name + " with value " + value + ".");
        }
        this.headers.put(headerName, valueList);
        return this;
    }

    @Override
    public UpdateResponseBuilder addHeader(String name, String value) {
        String headerName = this.getHeaderName(name);
        List<String> valueList = this.headers.get(headerName);
        if (valueList == null) {
            valueList = new ArrayList<String>();
        }
        valueList.add(value);
        if (log.isDebugEnabled()) {
            log.debug("Replace header name " + name + ". Setting name " + headerName + " with value " + value + ".");
        }
        this.headers.put(headerName, valueList);
        return this;
    }

    @Override
    public UpdateResponse response() {
        UpdateResponseImpl updateResponse = new UpdateResponseImpl();
        updateResponse.setHeaders(this.headers);
        updateResponse.audit(this.enable);
        return updateResponse;
    }

    @Override
    @Deprecated
    public UpdateResponseBuilder audit(boolean enable) {
        this.enable = enable;
        return this;
    }

    protected String getHeaderName(String name) {
        if (name == null || "".equals(name.trim()) || this.headers == null) {
            return name;
        }
        for (String headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return headerName;
        }
        return name;
    }
}

