/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.internal;

import com.sap.cloud.sdk.service.prov.api.annotations.Action;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterCreate;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterDelete;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterOperation;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterQuery;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterRead;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterUpdate;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeAll;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeCreate;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeDelete;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeOperation;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeQuery;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeRead;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeUpdate;
import com.sap.cloud.sdk.service.prov.api.annotations.CleanupTransaction;
import com.sap.cloud.sdk.service.prov.api.annotations.EndTransaction;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendAction;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendCreate;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendDelete;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendFunction;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendRead;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendReadStream;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendUpdate;
import com.sap.cloud.sdk.service.prov.api.annotations.Function;
import com.sap.cloud.sdk.service.prov.api.annotations.InitTransaction;
import com.sap.cloud.sdk.service.prov.api.operations.ChangeSet;
import com.sap.cloud.sdk.service.prov.api.operations.Create;
import com.sap.cloud.sdk.service.prov.api.operations.Delete;
import com.sap.cloud.sdk.service.prov.api.operations.Query;
import com.sap.cloud.sdk.service.prov.api.operations.Read;
import com.sap.cloud.sdk.service.prov.api.operations.Update;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class CustomHandlerAnnotations {
    static List<Class> customHandlerAnnotations = Arrays.asList(ExtendCreate.class, ExtendUpdate.class, ExtendDelete.class, ExtendRead.class, Query.class, Create.class, Update.class, Delete.class, Read.class, BeforeCreate.class, BeforeUpdate.class, BeforeDelete.class, BeforeQuery.class, BeforeRead.class, AfterCreate.class, AfterUpdate.class, AfterDelete.class, AfterQuery.class, AfterRead.class, InitTransaction.class, EndTransaction.class, CleanupTransaction.class, ExtendFunction.class, ExtendAction.class, Function.class, Action.class, BeforeOperation.class, AfterOperation.class, ExtendReadStream.class, BeforeAll.class, ChangeSet.class);

    private static boolean isCustomHandler(Method method) {
        for (Class annotationClass : customHandlerAnnotations) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtensionClass(Class c) {
        try {
            Method[] methods = c.getMethods();
            return Arrays.stream(methods).filter(m -> CustomHandlerAnnotations.isCustomHandler(m)).findFirst().isPresent();
        }
        catch (Throwable t) {
            if (t instanceof VirtualMachineError) {
                throw (VirtualMachineError)t;
            }
            return false;
        }
    }
}

