/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.x509.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContext.class);
    private static final ThreadLocal<Token> tokenStorage = new ThreadLocal();
    private static final ThreadLocal<List<String>> servicePlanStorage = new ThreadLocal();
    private static final ThreadLocal<Certificate> certificateStorage = new ThreadLocal();

    private SecurityContext() {
    }

    @Nullable
    public static Certificate getClientCertificate() {
        return certificateStorage.get();
    }

    public static void setClientCertificate(Certificate certificate) {
        LOGGER.debug("Sets certificate to SecurityContext (thread-locally). {}", (Object)certificate);
        certificateStorage.set(certificate);
    }

    private static void clearCertificate() {
        Certificate certificate = certificateStorage.get();
        if (certificate != null) {
            LOGGER.debug("Certificate removed from SecurityContext (thread-locally).");
            certificateStorage.remove();
        }
    }

    public static void setToken(Token token) {
        LOGGER.debug("Sets token of service {} to SecurityContext (thread-locally).", token != null ? token.getService() : "null");
        tokenStorage.set(token);
    }

    @Nullable
    public static Token getToken() {
        return tokenStorage.get();
    }

    @Nullable
    public static AccessToken getAccessToken() {
        return tokenStorage.get() instanceof AccessToken ? (AccessToken)tokenStorage.get() : null;
    }

    public static void clearToken() {
        Token token = tokenStorage.get();
        if (token != null) {
            LOGGER.debug("Token of service {} removed from SecurityContext (thread-locally).", (Object)token.getService());
            tokenStorage.remove();
        }
    }

    public static List<String> getServicePlans() {
        return servicePlanStorage.get();
    }

    public static void setServicePlans(String servicePlansHeader) {
        String[] planParts = servicePlansHeader.trim().split("\\s*,\\s*");
        List plans = Arrays.stream(planParts).map(plan -> plan.substring(1, plan.length() - 1)).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sets Identity Service Plan {} to SecurityContext (thread-locally).", plans);
        }
        servicePlanStorage.set(plans);
    }

    public static void clearServicePlans() {
        List<String> plans = servicePlanStorage.get();
        if (plans != null && plans.size() != 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Service plans {} removed from SecurityContext (thread-locally).", plans);
            }
            servicePlanStorage.remove();
        }
    }

    public static void clear() {
        SecurityContext.clearCertificate();
        SecurityContext.clearToken();
        SecurityContext.clearServicePlans();
    }
}

