/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.services.scp.blockchain.hyperledgerfabric;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.connectivity.ScpCfService;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.services.scp.blockchain.hyperledgerfabric.FabricInvocationType;
import com.sap.cloud.sdk.services.scp.blockchain.hyperledgerfabric.FabricServiceFailureException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FabricService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FabricService.class);
    private final ScpCfService cfService;
    private final String serviceUrl;

    private FabricService(ScpCfService cfService) throws CloudPlatformException {
        this.cfService = cfService;
        if (cfService.getServiceLocationInfo() == null) {
            throw new CloudPlatformException("Missing service location info on given service: " + cfService);
        }
        this.serviceUrl = cfService.getServiceLocationInfo();
    }

    @Nonnull
    public static FabricService create() throws CloudPlatformException {
        return FabricService.getFabricService("hyperledger-fabric");
    }

    @Nonnull
    public String invokeOrQuery(@Nonnull FabricInvocationType invocationType, @Nonnull String chainCodeId, @Nonnull String function, String ... params) throws FabricServiceFailureException, IllegalArgumentException, JsonIOException, CloudPlatformException {
        String json;
        HttpPost chaincodeEndpointRequest;
        List<String> argsList = Arrays.asList(params);
        if (log.isTraceEnabled()) {
            log.trace("{} {}:{}({})", new Object[]{invocationType, chainCodeId, function, argsList});
        } else {
            log.debug("{} {}:{}", new Object[]{invocationType, chainCodeId, function});
        }
        if (Strings.isNullOrEmpty((String)chainCodeId) || chainCodeId.matches(".*\\s.*")) {
            throw new IllegalArgumentException("Given chaincode id invalid - empty string or contains whitespace");
        }
        try {
            chaincodeEndpointRequest = new HttpPost(new URI(this.getServiceUrl() + "/chaincodes/" + chainCodeId + "/latest/" + invocationType.getPathParamValue()).normalize());
        }
        catch (URISyntaxException e) {
            throw new ShouldNotHappenException("URL for accessing fabric service problematic: " + e.getMessage(), (Throwable)e);
        }
        this.cfService.addBearerTokenHeader((HttpRequest)chaincodeEndpointRequest);
        chaincodeEndpointRequest.setHeader("Accept", "application/json;charset=UTF-8");
        LinkedHashMap<String, Object> requestBody = new LinkedHashMap<String, Object>();
        requestBody.put("function", function);
        requestBody.put("arguments", argsList);
        requestBody.put("async", false);
        try {
            json = new Gson().toJson(requestBody);
        }
        catch (JsonIOException e) {
            log.debug("Could not encode request: " + (Object)((Object)e));
            throw e;
        }
        log.trace("Request to be sent: {}", (Object)json);
        chaincodeEndpointRequest.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        chaincodeEndpointRequest.setHeader("Content-Type", "application/json");
        try {
            HttpResponse response = HttpClientAccessor.getHttpClient().execute((HttpUriRequest)chaincodeEndpointRequest);
            StatusLine statusLine = response.getStatusLine();
            String responseBody = HttpEntityUtil.getResponseBody((HttpResponse)response);
            if (responseBody == null) {
                throw new FabricServiceFailureException("Failed to execute request to function " + function + ": no body returned in response.");
            }
            if (log.isTraceEnabled()) {
                log.trace("Response status: {}, content: {}", (Object)statusLine, (Object)responseBody);
            } else {
                log.debug("Response status: {}", (Object)statusLine);
            }
            switch (statusLine.getStatusCode()) {
                case 200: {
                    String string = responseBody;
                    return string;
                }
            }
            try {
                throw new FabricServiceFailureException("Failed to execute request to function " + function + ": Service request failed with status: " + statusLine + ".");
            }
            catch (HttpClientInstantiationException | IOException e) {
                String message = "Failed to execute request to function " + function + ": " + e.getMessage();
                log.debug(message, e);
                throw new FabricServiceFailureException(message, e);
            }
        }
        finally {
            chaincodeEndpointRequest.releaseConnection();
        }
    }

    static FabricService getFabricService(@Nonnull String serviceType) throws CloudPlatformException {
        ScpCfService cfService = ScpCfService.of((String)serviceType, null, (String)"credentials/oAuth/url", (String)"credentials/oAuth/clientId", (String)"credentials/oAuth/clientSecret", (String)"credentials/serviceUrl");
        return new FabricService(cfService);
    }

    @Nonnull
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Nonnull
    public String toString() {
        return "FabricService{cfService=" + this.cfService + '}';
    }
}

