/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.cxf.security;

import com.sap.cloud.sdk.cloudplatform.security.Role;
import com.sap.cloud.sdk.cloudplatform.security.RolesAllowed;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SecureAnnotationsInterceptor
extends org.apache.cxf.interceptor.security.SecureAnnotationsInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecureAnnotationsInterceptor.class);

    public SecureAnnotationsInterceptor() {
        this.setAnnotationClassName(RolesAllowed.class.getName());
    }

    public void handleMessage(@Nonnull Message message) throws Fault {
        Exchange exchange = message.getExchange();
        Endpoint endpoint = (Endpoint)exchange.get(Endpoint.class);
        Service service = endpoint.getService();
        Invoker invoker = service.getInvoker();
        JAXRSInvoker jaxrsInvoker = (JAXRSInvoker)invoker;
        Object serviceObject = jaxrsInvoker.getServiceObject(exchange);
        Class cls = ClassHelper.getRealClass((Object)serviceObject);
        HashMap<String, String> rolesMap = new HashMap<String, String>();
        super.findRoles(cls, rolesMap);
        this.methodRolesMap = SecureAnnotationsInterceptor.parseRolesMap(rolesMap);
        this.checkUser(message);
    }

    protected static Map<String, List<String>> parseRolesMap(Map<String, String> rolesMap) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : rolesMap.entrySet()) {
            map.put(entry.getKey(), Arrays.asList(StringUtils.split((String)entry.getValue(), (String)" ")));
        }
        return map;
    }

    protected static void throwUnauthorized(List<String> expectedRoles) {
        String messageText = "Required roles: " + expectedRoles + ".";
        log.debug(messageText);
        throw new AccessDeniedException(messageText);
    }

    protected void checkUser(Message message) throws Fault {
        Method method = this.getTargetMethod(message);
        List expectedRoles = this.getExpectedRoles(method);
        if (expectedRoles.isEmpty()) {
            return;
        }
        for (String role : expectedRoles) {
            if (((Set)PrincipalAccessor.tryGetCurrentPrincipal().map(Principal::getAuthorizations).getOrElseThrow(() -> new PrincipalAccessException("No principal available."))).contains(new Role(role))) continue;
            SecureAnnotationsInterceptor.throwUnauthorized(expectedRoles);
        }
    }
}

