/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import com.sap.cloud.environment.servicebinding.api.DefaultServiceBindingAccessor;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.DefaultTenant;
import com.sap.cloud.sdk.cloudplatform.tenant.ServiceBindingTenantExtractor;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTenantFacade
implements TenantFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultTenantFacade.class);
    private static final String XSUAA_JWT_ZONE_ID = "zid";
    private static final String IAS_JWT_ZONE_ID = "zone_uuid";
    private static final String IAS_JWT_APP_TID = "app_tid";
    private static final List<String> TENANT_ID_CLAIMS = Arrays.asList("zid", "app_tid", "zone_uuid");
    private static final String JWT_ISSUER = "iss";

    @Nonnull
    private String getTenantId(@Nonnull Payload jwt) {
        Optional<String> maybeTenantId = TENANT_ID_CLAIMS.stream().map(id -> jwt.getClaim(id).asString()).filter(Objects::nonNull).findFirst();
        if (!maybeTenantId.isPresent()) {
            throw new TenantAccessException("No tenant identifier (one of these elements [" + String.valueOf(TENANT_ID_CLAIMS) + "]) found in JWT.");
        }
        return maybeTenantId.get();
    }

    @Nonnull
    private String getIssuer(@Nonnull DecodedJWT jwt) {
        String issuer = jwt.getClaim(JWT_ISSUER).asString();
        if (issuer == null) {
            throw new TenantAccessException("No subdomain ('iss' element) found in JWT.");
        }
        return issuer;
    }

    @Nonnull
    private String getSubdomain(@Nonnull URI issuerUri) {
        String host = issuerUri.getHost();
        if (host == null || !host.contains(".")) {
            throw new TenantAccessException("Failed to get subdomain from issuer URI '" + String.valueOf(issuerUri) + "'.");
        }
        return host.split("\\.")[0];
    }

    @Override
    @Nonnull
    public Try<Tenant> tryGetCurrentTenant() {
        Try tenantFromThreadContextTry = ThreadContextAccessor.tryGetCurrentContext().flatMap(c -> c.getPropertyValue(TenantThreadContextListener.PROPERTY_TENANT));
        if (tenantFromThreadContextTry.isSuccess()) {
            return tenantFromThreadContextTry;
        }
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        throwables.add(tenantFromThreadContextTry.getCause());
        return this.tryGetTenantFromAuthToken((Try<AuthToken>)AuthTokenAccessor.tryGetCurrentToken()).onFailure(throwables::add).orElse(this::tryGetTenantFromServiceBinding).onFailure(throwables::add).orElse(() -> this.createFallbackException(throwables));
    }

    private Try<Tenant> createFallbackException(@Nonnull List<? extends Throwable> throwables) {
        TenantAccessException resultingException = new TenantAccessException("Failed to get current tenant.");
        throwables.forEach(resultingException::addSuppressed);
        return Try.failure((Throwable)resultingException);
    }

    @Nonnull
    private Try<Tenant> tryGetTenantFromAuthToken(@Nonnull Try<AuthToken> authToken) {
        Try jwtTry = authToken.map(AuthToken::getJwt);
        if (jwtTry.isFailure()) {
            return Try.failure((Throwable)jwtTry.getCause());
        }
        Try tenantIdTry = jwtTry.map(this::getTenantId);
        if (tenantIdTry.isFailure()) {
            return Try.failure((Throwable)tenantIdTry.getCause());
        }
        Try subdomainTry = jwtTry.map(this::getIssuer).map(URI::create).map(this::getSubdomain);
        if (subdomainTry.isFailure()) {
            return Try.failure((Throwable)subdomainTry.getCause());
        }
        return Try.of((CheckedFunction0 & Serializable)() -> new DefaultTenant((String)tenantIdTry.get(), (String)subdomainTry.get()));
    }

    @Nonnull
    private Try<DefaultTenant> tryGetTenantFromServiceBinding() {
        List serviceBindings = DefaultServiceBindingAccessor.getInstance().getServiceBindings();
        for (ServiceBindingTenantExtractor extractor : ServiceBindingTenantExtractor.values()) {
            Optional tenant = this.streamServiceCredentialsByPlan(serviceBindings, extractor.getService()).peek(obj -> log.trace("Trying to extract tenant information from service binding {}.", obj)).flatMap(obj -> extractor.getExtractor().apply((Map<String, Object>)obj).toJavaStream()).findFirst();
            if (!tenant.isPresent()) continue;
            return Try.success((Object)((DefaultTenant)tenant.get()));
        }
        return Try.failure((Throwable)new CloudPlatformException("Failed to extract tenant from service bindings."));
    }

    @Nonnull
    private Stream<Map<String, Object>> streamServiceCredentialsByPlan(@Nonnull Collection<ServiceBinding> serviceBindings, @Nonnull String serviceName) {
        return serviceBindings.stream().filter(binding -> serviceName.equals(binding.getServiceName().orElse(null))).map(ServiceBinding::getCredentials);
    }

    @Nullable
    <T> T executeWithTenant(@Nonnull Tenant tenant, @Nonnull Callable<T> callable) {
        return (T)ThreadContextExecutor.fromCurrentOrNewContext().withListeners(new ThreadContextListener[]{new TenantThreadContextListener(tenant)}).execute(callable);
    }
}

