/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.principal;

import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.security.principal.DefaultPrincipal;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalExtractor;
import com.sap.cloud.sdk.cloudplatform.security.principal.exception.PrincipalAccessException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.annotation.Nonnull;

class OidcAuthTokenPrincipalExtractor
implements PrincipalExtractor {
    private static final String JWT_USER_UUID_CLAIM = "user_uuid";

    OidcAuthTokenPrincipalExtractor() {
    }

    @Override
    @Nonnull
    public Try<Principal> tryGetCurrentPrincipal() {
        Try jwtTry = AuthTokenAccessor.tryGetCurrentToken().map(AuthToken::getJwt);
        if (jwtTry.isFailure()) {
            return Try.failure((Throwable)jwtTry.getCause());
        }
        DecodedJWT jwt = (DecodedJWT)jwtTry.get();
        Try<String> principalIdTry = this.tryGetPrincipalId(jwt);
        if (principalIdTry.isFailure()) {
            return Try.failure((Throwable)principalIdTry.getCause());
        }
        String principalId = (String)principalIdTry.get();
        return Try.of((CheckedFunction0 & Serializable)() -> new DefaultPrincipal(principalId));
    }

    private Try<String> tryGetPrincipalId(@Nonnull DecodedJWT jwt) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            Claim userUuidClaim = jwt.getClaim(JWT_USER_UUID_CLAIM);
            if (userUuidClaim.isMissing() || userUuidClaim.isNull()) {
                throw new PrincipalAccessException("The current JWT does not contain the IAS user uuid.");
            }
            return userUuidClaim.asString();
        });
    }
}

