/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.secret;

import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStore;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStoreFacade;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.KeyStoreAccessException;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.SecretStoreAccessException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import java.security.KeyStore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class SecretStoreAccessor {
    @Nonnull
    private static Try<SecretStoreFacade> secretStoreFacade = FacadeLocator.getFacade(SecretStoreFacade.class);

    @Nullable
    public static SecretStoreFacade getSecretStoreFacade() {
        return (SecretStoreFacade)secretStoreFacade.getOrNull();
    }

    @Nonnull
    public static Try<SecretStoreFacade> tryGetSecretStoreFacade() {
        return secretStoreFacade;
    }

    public static void setSecretStoreFacade(@Nullable SecretStoreFacade secretStoreFacade) {
        SecretStoreAccessor.secretStoreFacade = secretStoreFacade == null ? FacadeLocator.getFacade(SecretStoreFacade.class) : Try.success((Object)secretStoreFacade);
    }

    @Nonnull
    public static SecretStore getSecretStore(@Nonnull String name) throws SecretStoreAccessException {
        return (SecretStore)SecretStoreAccessor.tryGetSecretStore(name).getOrElseThrow(failure -> {
            if (failure instanceof SecretStoreAccessException) {
                throw (SecretStoreAccessException)failure;
            }
            throw new SecretStoreAccessException("Failed to get secret store with name'" + name + "'.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<SecretStore> tryGetSecretStore(@Nonnull String name) {
        return secretStoreFacade.flatMap(facade -> facade.tryGetSecretStore(name));
    }

    @Nonnull
    public static KeyStore getKeyStore(@Nonnull String name, @Nonnull SecretStore password) throws KeyStoreAccessException {
        return (KeyStore)SecretStoreAccessor.tryGetKeyStore(name, password).getOrElseThrow(failure -> {
            if (failure instanceof SecretStoreAccessException) {
                throw (SecretStoreAccessException)failure;
            }
            throw new SecretStoreAccessException("Failed to get key store with name '" + name + "'.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<KeyStore> tryGetKeyStore(@Nonnull String name, @Nonnull SecretStore password) {
        return secretStoreFacade.flatMap(facade -> facade.tryGetKeyStore(name, password));
    }

    @Generated
    private SecretStoreAccessor() {
    }
}

