/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.resilience;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.cache.GenericCacheKey;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationKey;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface CacheFilter {
    public boolean matches(@Nonnull ResilienceConfiguration var1, @Nonnull GenericCacheKey<?, ?> var2, @Nullable Object var3);

    @Nonnull
    public static CacheFilter keyMatchesTenant(@Nonnull Tenant tenant) {
        return (configuration, cacheKey, cacheEntry) -> Objects.equals(cacheKey.getTenantId().getOrNull(), tenant.getTenantId());
    }

    @Nonnull
    public static CacheFilter keyMatchesPrincipal() {
        return (configuration, cacheKey, cacheEntry) -> {
            ResilienceIsolationKey isolationKey = ResilienceIsolationKey.of(configuration.isolationMode());
            String principalId = isolationKey.getPrincipal() == null ? null : isolationKey.getPrincipal().getPrincipalId();
            return Objects.equals(cacheKey.getPrincipalId().getOrNull(), principalId);
        };
    }

    @Nonnull
    public static CacheFilter keyMatchesPrincipal(@Nonnull Principal principal) {
        return (configuration, cacheKey, cacheEntry) -> Objects.equals(cacheKey.getPrincipalId().getOrNull(), principal.getPrincipalId());
    }

    @Nonnull
    public static CacheFilter keyMatchesTenant() {
        return (configuration, cacheKey, cacheEntry) -> {
            ResilienceIsolationKey isolationKey = ResilienceIsolationKey.of(configuration.isolationMode());
            String tenantId = isolationKey.getTenant() == null ? null : isolationKey.getTenant().getTenantId();
            return Objects.equals(cacheKey.getTenantId().getOrNull(), tenantId);
        };
    }

    @Nonnull
    public static CacheFilter keyMatchesParameters() {
        return (configuration, cacheKey, cacheEntry) -> Iterables.elementsEqual((Iterable)cacheKey.getComponents(), configuration.cacheConfiguration().parameters());
    }

    @Nonnull
    public static CacheFilter keyMatchesParameters(@Nonnull Iterable<Object> parameters) {
        return (configuration, cacheKey, cacheEntry) -> Iterables.elementsEqual((Iterable)cacheKey.getComponents(), (Iterable)parameters);
    }

    @Nonnull
    public static CacheFilter and(@Nonnull CacheFilter firstFilter, CacheFilter ... additionalFilters) {
        return (configuration, cacheKey, cacheEntry) -> {
            ArrayList allFilters = Lists.newArrayList((Object[])additionalFilters);
            allFilters.add(0, firstFilter);
            return allFilters.stream().allMatch(cacheFilter -> cacheFilter.matches(configuration, cacheKey, cacheEntry));
        };
    }

    @Nonnull
    public static CacheFilter or(@Nonnull CacheFilter firstFilter, CacheFilter ... additionalFilters) {
        return (configuration, cacheKey, cacheEntry) -> {
            ArrayList allFilters = Lists.newArrayList((Object[])additionalFilters);
            allFilters.add(0, firstFilter);
            return allFilters.stream().anyMatch(cacheFilter -> cacheFilter.matches(configuration, cacheKey, cacheEntry));
        };
    }
}

