/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import io.vavr.control.Try;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);
    private static final List<Cache<CacheKey, ?>> cacheList = new ArrayList();

    @Nonnull
    public static ImmutableList<Cache<CacheKey, ?>> getCacheList() {
        return ImmutableList.copyOf(cacheList);
    }

    @Nonnull
    public static synchronized <T> Cache<CacheKey, T> register(@Nonnull Cache<CacheKey, T> cache) {
        cacheList.add(cache);
        return cache;
    }

    @Nonnull
    public static synchronized <T> Cache<CacheKey, T> unregister(@Nonnull Cache<CacheKey, T> cache) {
        cacheList.remove(cache);
        return cache;
    }

    public static void cleanUp() {
        for (Cache<CacheKey, ?> cache : cacheList) {
            cache.cleanUp();
        }
        log.info("Clean up of invalidated caches finished successfully.");
    }

    public static long invalidateAll() {
        long size = 0L;
        for (Cache<CacheKey, ?> cache : cacheList) {
            size += cache.estimatedSize();
            cache.invalidateAll();
        }
        log.info("Successfully invalidated roughly {} entries in {} caches.", (Object)size, (Object)cacheList.size());
        return size;
    }

    public static long invalidateTenantCaches() {
        Try tenantTry = TenantAccessor.tryGetCurrentTenant();
        if (tenantTry.isSuccess()) {
            return CacheManager.invalidateTenantCaches(((Tenant)tenantTry.get()).getTenantId());
        }
        log.debug("Cache could not be invalidated for tenant.", tenantTry.getCause());
        return 0L;
    }

    public static long invalidateTenantCaches(@Nullable String tenantId) {
        long size = 0L;
        for (Cache<CacheKey, ?> cache : cacheList) {
            ArrayList<CacheKey> keysToInvalidate = new ArrayList<CacheKey>();
            for (CacheKey cacheKey : cache.asMap().keySet()) {
                log.debug("Checking cache invalidation for tenant '{}': {}.", (Object)tenantId, (Object)cacheKey);
                if (!Objects.equals(tenantId, cacheKey.getTenantId().getOrNull())) continue;
                keysToInvalidate.add(cacheKey);
            }
            log.debug("Invalidating caches of tenant '{}': {}.", (Object)tenantId, keysToInvalidate);
            size += (long)keysToInvalidate.size();
            cache.invalidateAll(keysToInvalidate);
        }
        log.info("Successfully invalidated caches of tenant '{}': {}.", (Object)tenantId, (Object)size);
        return size;
    }

    public static long invalidatePrincipalCaches() {
        Try tenantTry = TenantAccessor.tryGetCurrentTenant();
        Try principalTry = PrincipalAccessor.tryGetCurrentPrincipal();
        if (tenantTry.isSuccess() && principalTry.isSuccess()) {
            return CacheManager.invalidatePrincipalCaches(((Tenant)tenantTry.get()).getTenantId(), ((Principal)principalTry.get()).getPrincipalId());
        }
        return 0L;
    }

    public static long invalidatePrincipalCaches(@Nullable String tenantId, @Nullable String principalId) {
        long size = 0L;
        for (Cache<CacheKey, ?> cache : cacheList) {
            log.debug("Invalidating principal cache entries.");
            size += CacheManager.invalidatePrincipalEntries(tenantId, principalId, cache);
        }
        String msg = "Successfully invalidated caches of principal {} within tenant {}: {}";
        log.info("Successfully invalidated caches of principal {} within tenant {}: {}", new Object[]{principalId, tenantId, size});
        return size;
    }

    public static long invalidatePrincipalEntries(@Nonnull Cache<CacheKey, ?> cache) {
        Try tenantTry = TenantAccessor.tryGetCurrentTenant();
        tenantTry.onFailure(e -> log.debug("Cache could not be invalidated for tenant.", e));
        Try principalTry = PrincipalAccessor.tryGetCurrentPrincipal();
        principalTry.onFailure(e -> log.debug("Cache could not be invalidated for principal.", e));
        if (tenantTry.isSuccess() && principalTry.isSuccess()) {
            return CacheManager.invalidatePrincipalEntries(((Tenant)tenantTry.get()).getTenantId(), ((Principal)principalTry.get()).getPrincipalId(), cache);
        }
        return 0L;
    }

    public static long invalidatePrincipalEntries(@Nullable String tenantId, @Nullable String principalId, @Nonnull Cache<CacheKey, ?> cache) {
        ArrayList<CacheKey> keysToInvalidate = new ArrayList<CacheKey>();
        for (CacheKey cacheKey : cache.asMap().keySet()) {
            String msg = "Checking invalidation for principal {} within tenant {}: {}";
            log.debug("Checking invalidation for principal {} within tenant {}: {}", new Object[]{principalId, tenantId, cacheKey});
            boolean isEqualTenantId = Objects.equals(tenantId, cacheKey.getTenantId().getOrNull());
            boolean isEqualPrincipalId = Objects.equals(principalId, cacheKey.getPrincipalId().getOrNull());
            if (!isEqualTenantId || !isEqualPrincipalId) continue;
            keysToInvalidate.add(cacheKey);
        }
        String msg = "Invalidating caches of principal '{}' within tenant '{}': {}";
        log.debug("Invalidating caches of principal '{}' within tenant '{}': {}", new Object[]{principalId, tenantId, keysToInvalidate});
        long size = keysToInvalidate.size();
        cache.invalidateAll(keysToInvalidate);
        return size;
    }
}

