/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.cache;

import com.sap.cloud.sdk.cloudplatform.cache.GenericCacheKey;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import io.vavr.control.Option;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class SerializableCacheKey
implements GenericCacheKey<SerializableCacheKey, Serializable>,
Serializable {
    private static final long serialVersionUID = 4042868809324769786L;
    @Nullable
    private final String tenantId;
    @Nullable
    private final String principalId;
    private final List<Serializable> components = new ArrayList<Serializable>();

    @Override
    @Nonnull
    public Option<String> getTenantId() {
        return Option.of((Object)this.tenantId);
    }

    @Override
    @Nonnull
    public Option<String> getPrincipalId() {
        return Option.of((Object)this.principalId);
    }

    @Override
    @Nonnull
    public SerializableCacheKey append(@Nonnull Iterable<Serializable> objects) throws IllegalArgumentException {
        for (Serializable object : objects) {
            if (object == null) {
                throw new IllegalArgumentException("Object must not be null.");
            }
            this.components.add(object);
        }
        return this;
    }

    @Nonnull
    public static SerializableCacheKey of(@Nullable String tenantId, @Nullable String principalId) {
        return new SerializableCacheKey(tenantId, principalId);
    }

    @Nonnull
    public static SerializableCacheKey of(@Nullable Tenant tenant, @Nullable Principal principal) {
        return new SerializableCacheKey(tenant != null ? tenant.getTenantId() : null, principal != null ? principal.getPrincipalId() : null);
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializableCacheKey)) {
            return false;
        }
        SerializableCacheKey other = (SerializableCacheKey)o;
        Option<String> this$tenantId = this.getTenantId();
        Option<String> other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Option<String> this$principalId = this.getPrincipalId();
        Option<String> other$principalId = other.getPrincipalId();
        if (this$principalId == null ? other$principalId != null : !this$principalId.equals(other$principalId)) {
            return false;
        }
        List<Serializable> this$components = this.getComponents();
        List<Serializable> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Option<String> $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Option<String> $principalId = this.getPrincipalId();
        result = result * 59 + ($principalId == null ? 43 : $principalId.hashCode());
        List<Serializable> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "SerializableCacheKey(tenantId=" + this.getTenantId() + ", principalId=" + this.getPrincipalId() + ", components=" + this.getComponents() + ")";
    }

    @Generated
    private SerializableCacheKey(@Nullable String tenantId, @Nullable String principalId) {
        this.tenantId = tenantId;
        this.principalId = principalId;
    }

    @Override
    @Generated
    public List<Serializable> getComponents() {
        return this.components;
    }
}

