/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextFacade;
import com.sap.cloud.sdk.cloudplatform.servlet.ThreadLocalRequestContextFacade;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

public final class RequestContextAccessor {
    private static final Logger logger = CloudLoggerFactory.getLogger(RequestContextAccessor.class);
    private static RequestContextFacade requestContextFacade;

    private static RequestContextFacade facade() {
        return requestContextFacade;
    }

    public static void setRequestContextFacade(@Nonnull RequestContextFacade requestContextFacade) {
        RequestContextAccessor.requestContextFacade = requestContextFacade;
    }

    @Nonnull
    public static Optional<RequestContext> getCurrentRequestContext() {
        return RequestContextAccessor.facade().getCurrentRequestContext();
    }

    @Nonnull
    public static Optional<HttpServletRequest> getCurrentRequest() {
        return RequestContextAccessor.facade().getCurrentRequest();
    }

    public static RequestContextFacade getRequestContextFacade() {
        return requestContextFacade;
    }

    static {
        RequestContextFacade facade = (RequestContextFacade)FacadeLocator.getFacade(RequestContextFacade.class);
        if (facade != null) {
            requestContextFacade = facade;
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to look up implementation of " + RequestContextFacade.class.getSimpleName() + ". Falling back to " + ThreadLocalRequestContextFacade.class.getSimpleName() + ".");
            }
            requestContextFacade = new ThreadLocalRequestContextFacade();
        }
    }
}

