/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import javax.annotation.Nullable;

public class Property<T> {
    @Nullable
    private final T value;
    @Nullable
    private final Exception exception;
    private final boolean isConfidential;

    protected Property(@Nullable T value, @Nullable Exception exception, boolean isConfidential) {
        this.value = value;
        this.exception = exception;
        this.isConfidential = isConfidential;
    }

    public static <T> Property<T> empty() {
        return new Property<Object>(null, null, false);
    }

    public static <T> Property<T> ofValue(@Nullable T value) {
        return new Property<T>(value, null, false);
    }

    public static <T> Property<T> ofException(@Nullable Exception exception) {
        return new Property<Object>(null, exception, false);
    }

    public static <T> Property<T> ofConfidentialValue(@Nullable T confidentialValue) {
        return new Property<T>(confidentialValue, null, true);
    }

    public static <T> Property<T> ofConfidentialException(@Nullable Exception confidentialException) {
        return new Property<Object>(null, confidentialException, true);
    }

    public String toString() {
        return this.isConfidential ? "Property(value=" + (this.value != null ? "(hidden)" : null) + ", exception=" + (this.exception != null ? "(hidden)" : null) + ")" : "Property(value=" + this.value + ", exception=" + this.exception + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Exception this$exception = this.getException();
        Exception other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        return this.isConfidential() == other.isConfidential();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Exception $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        result = result * 59 + (this.isConfidential() ? 79 : 97);
        return result;
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public boolean isConfidential() {
        return this.isConfidential;
    }
}

