/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public abstract class AbstractRequestContextListener
implements RequestContextListener {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractRequestContextListener.class);

    @Nonnull
    protected abstract Map<String, Property<?>> getProperties(@Nonnull RequestContext var1);

    @Override
    public void requestContextInitialized(@Nonnull RequestContext requestContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received notification of " + RequestContext.class.getSimpleName() + " initialization in " + this.getClass().getSimpleName() + ".");
        }
        Map<String, Property<?>> properties = this.getProperties(requestContext);
        try {
            for (Map.Entry<String, Property<?>> entry : properties.entrySet()) {
                requestContext.setPropertyIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        catch (RequestContextPropertyException e) {
            logger.error("Failed to initialize " + this.getClass().getSimpleName() + ".", (Throwable)e);
        }
    }

    @Override
    public void requestContextDestroyed(@Nonnull RequestContext requestContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("Received notification of " + RequestContext.class.getSimpleName() + " destruction in " + this.getClass().getSimpleName() + ".");
        }
        Set<String> properties = this.getProperties(requestContext).keySet();
        try {
            for (String property : properties) {
                requestContext.removeProperty(property);
            }
        }
        catch (RequestContextPropertyException e) {
            logger.error("Failed to destroy " + this.getClass().getSimpleName() + ".", (Throwable)e);
        }
    }
}

