/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.slf4j.Logger;

public class DefaultRequestContext
implements RequestContext {
    private static final Logger logger = CloudLoggerFactory.getLogger(DefaultRequestContext.class);
    @Nullable
    private final HttpServletRequest request;
    private final long requestThreadId = Thread.currentThread().getId();
    private final ConcurrentMap<String, Object> properties = Maps.newConcurrentMap();

    DefaultRequestContext(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public Optional<HttpServletRequest> getRequest() {
        return Optional.fromNullable((Object)this.request);
    }

    @Override
    public Optional<Object> getProperty(@NonNull String name) throws RequestContextPropertyException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            Optional value = Optional.fromNullable(this.properties.get(name));
            if (logger.isDebugEnabled()) {
                if (value.isPresent()) {
                    logger.debug("Retrieved value of property \"" + name + "\": " + value.get() + ".");
                } else {
                    logger.debug("Property \"" + name + "\" does not exist, returning absent.");
                }
            }
            return value;
        }
        catch (ClassCastException | NullPointerException e) {
            throw new RequestContextPropertyException(e);
        }
    }

    @Override
    public void setPropertyIfAbsent(@NonNull String name, @NonNull Object value) throws RequestContextPropertyException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Setting property \"" + name + "\": " + value + ".");
        }
        try {
            Object previous = this.properties.putIfAbsent(name, value);
            if (previous != null) {
                throw new RequestContextPropertyException("Failed to set property \"" + name + "\". Properties may only be set once.");
            }
        }
        catch (ClassCastException | IllegalArgumentException | NullPointerException | UnsupportedOperationException e) {
            throw new RequestContextPropertyException(e);
        }
    }

    @Override
    public Optional<Object> removeProperty(@NonNull String name) throws RequestContextPropertyException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            Optional value = Optional.fromNullable(this.properties.remove(name));
            if (logger.isDebugEnabled()) {
                if (value.isPresent()) {
                    logger.debug("Removed property \"" + name + "\": " + value.get() + ".");
                } else {
                    logger.debug("Removing property \"" + name + "\" not required, does not exist.");
                }
            }
            return value;
        }
        catch (ClassCastException | NullPointerException | UnsupportedOperationException e) {
            throw new RequestContextPropertyException(e);
        }
    }

    public String toString() {
        String currentUser;
        String string = currentUser = this.request == null ? null : this.request.getRemoteUser();
        String sessionId = this.request == null ? null : (this.request.getSession(false) == null ? null : this.request.getSession(false).getId());
        return this.getClass().getSimpleName() + "(requestThreadId=" + this.requestThreadId + ", user=" + currentUser + ", sessionId=" + sessionId + ")";
    }

    public ConcurrentMap<String, Object> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultRequestContext)) {
            return false;
        }
        DefaultRequestContext other = (DefaultRequestContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<HttpServletRequest> this$request = this.getRequest();
        Optional<HttpServletRequest> other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        if (this.getRequestThreadId() != other.getRequestThreadId()) {
            return false;
        }
        ConcurrentMap<String, Object> this$properties = this.getProperties();
        ConcurrentMap<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !this$properties.equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultRequestContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<HttpServletRequest> $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        long $requestThreadId = this.getRequestThreadId();
        result = result * 59 + (int)($requestThreadId >>> 32 ^ $requestThreadId);
        ConcurrentMap<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    @Override
    public long getRequestThreadId() {
        return this.requestThreadId;
    }
}

