/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.security.user;

import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractUser
implements User {
    @Nonnull
    private final String name;
    @Nullable
    private final Locale locale;
    @Nonnull
    private final Set<Authorization> authorizations;
    @Nonnull
    private final Map<String, UserAttribute> attributes;

    @Override
    @Nonnull
    public Optional<Locale> getLocale() {
        return Optional.ofNullable(this.locale);
    }

    @Override
    public boolean hasAuthorization(@Nonnull Authorization authorization) {
        return this.authorizations.contains(authorization);
    }

    @Override
    @Nonnull
    public Set<Authorization> getAuthorizations() {
        return Sets.newHashSet(this.authorizations);
    }

    @Override
    @Nonnull
    public Optional<UserAttribute> getAttribute(@Nonnull String name) {
        return Optional.ofNullable(this.attributes.get(name));
    }

    public AbstractUser(@Nonnull String name, @Nullable Locale locale, @Nonnull Set<Authorization> authorizations, @Nonnull Map<String, UserAttribute> attributes) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (authorizations == null) {
            throw new NullPointerException("authorizations is marked @NonNull but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked @NonNull but is null");
        }
        this.name = name;
        this.locale = locale;
        this.authorizations = authorizations;
        this.attributes = attributes;
    }

    @Nonnull
    public Map<String, UserAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractUser)) {
            return false;
        }
        AbstractUser other = (AbstractUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Optional<Locale> this$locale = this.getLocale();
        Optional<Locale> other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        Set<Authorization> this$authorizations = this.getAuthorizations();
        Set<Authorization> other$authorizations = other.getAuthorizations();
        if (this$authorizations == null ? other$authorizations != null : !((Object)this$authorizations).equals(other$authorizations)) {
            return false;
        }
        Map<String, UserAttribute> this$attributes = this.getAttributes();
        Map<String, UserAttribute> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Optional<Locale> $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        Set<Authorization> $authorizations = this.getAuthorizations();
        result = result * 59 + ($authorizations == null ? 43 : ((Object)$authorizations).hashCode());
        Map<String, UserAttribute> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractUser(name=" + this.getName() + ", locale=" + this.getLocale() + ", authorizations=" + this.getAuthorizations() + ", attributes=" + this.getAttributes() + ")";
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }
}

