/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserAccessException;
import com.sap.cloud.sdk.cloudplatform.security.user.exception.UserNotAuthenticatedException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantNotAvailableException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.http.client.HttpClient;

public class TimeScopedHttpClientCache
extends HttpClientCache {
    private final Cache<CacheKey, HttpClient> cache;

    public TimeScopedHttpClientCache(long duration, @Nonnull TimeUnit unit) {
        this.cache = this.getCacheBuilder(duration, unit).build();
    }

    protected CacheBuilder<Object, Object> getCacheBuilder(long duration, @Nonnull TimeUnit unit) {
        return CacheBuilder.newBuilder().expireAfterWrite(duration, unit);
    }

    @Override
    @Nonnull
    protected Optional<Cache<CacheKey, HttpClient>> getCache() {
        return Optional.of(this.cache);
    }

    @Override
    @Nonnull
    protected CacheKey getCacheKey(@Nonnull Destination destination) throws HttpClientInstantiationException {
        try {
            return CacheKey.ofTenantAndUserIsolation().append(new Object[]{destination.getName()});
        }
        catch (UserAccessException | UserNotAuthenticatedException | TenantAccessException | TenantNotAvailableException | IllegalArgumentException e) {
            throw new HttpClientInstantiationException("Failed to get cache key.", e);
        }
    }

    @Override
    @Nonnull
    protected CacheKey getCacheKey() throws HttpClientInstantiationException {
        try {
            return CacheKey.ofTenantAndUserIsolation();
        }
        catch (UserAccessException | UserNotAuthenticatedException | TenantAccessException | TenantNotAvailableException | IllegalArgumentException e) {
            throw new HttpClientInstantiationException("Failed to get cache key.", e);
        }
    }
}

