/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.AbstractRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;

public class DestinationsRequestContextListener
extends AbstractRequestContextListener {
    private static final Logger logger = CloudLoggerFactory.getLogger(DestinationsRequestContextListener.class);
    public static final String PROPERTY_HTTP_CLIENTS = DestinationsRequestContextListener.class.getName() + ":httpClients";

    public int getPriority() {
        return -2;
    }

    @Nonnull
    protected Map<String, Property<?>> getProperties(@Nonnull RequestContext requestContext) {
        HashMap properties = new HashMap();
        properties.put(PROPERTY_HTTP_CLIENTS, Property.ofValue((Object)CacheBuilder.newBuilder().concurrencyLevel(10).build()));
        return properties;
    }

    public void requestContextDestroyed(@Nonnull RequestContext requestContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking requestContextDestroyed().");
        }
        try {
            Optional property = requestContext.removeProperty(PROPERTY_HTTP_CLIENTS);
            Cache cache = property.map(Property::getValue).orElse(null);
            if (cache != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Invalidating " + HttpClient.class.getSimpleName() + " cache.");
                }
                cache.invalidateAll();
                cache.cleanUp();
            }
        }
        catch (RequestContextPropertyException e) {
            logger.error("Failed to destroy " + ((Object)((Object)this)).getClass().getSimpleName() + ".", (Throwable)e);
        }
    }
}

