/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public enum AuthenticationType {
    NO_AUTHENTICATION("NoAuthentication"),
    BASIC_AUTHENTICATION("BasicAuthentication"),
    PRINCIPAL_PROPAGATION("PrincipalPropagation"),
    CLIENT_CERTIFICATE_AUTHENTICATION("ClientCertificateAuthentication"),
    APP_TO_APP_SSO("AppToAppSSO"),
    OAUTH2_CLIENT_CREDENTIALS("OAuth2ClientCredentials"),
    OAUTH2_SAML_BEARER_ASSERTION("OAuth2SAMLBearerAssertion"),
    OAUTH2_USER_TOKEN_EXCHANGE("OAuth2UserTokenExchange"),
    SAP_ASSERTION_SSO("SAPAssertionSSO"),
    INTERNAL_SYSTEM_AUTHENTICATION("InternalSystemAuthentication");

    private static final Logger logger;
    private final String identifier;

    private AuthenticationType(String identifier) {
        this.identifier = identifier;
    }

    public String toString() {
        return this.identifier;
    }

    @Nonnull
    public static AuthenticationType ofIdentifier(@Nonnull String identifier) throws IllegalArgumentException {
        for (AuthenticationType authenticationType : AuthenticationType.values()) {
            if (!authenticationType.getIdentifier().equals(identifier)) continue;
            return authenticationType;
        }
        throw new IllegalArgumentException("Unknown " + AuthenticationType.class.getSimpleName() + ": " + identifier + ".");
    }

    @Nonnull
    public static AuthenticationType ofIdentifierOrDefault(@Nullable String identifier, @Nonnull AuthenticationType defaultAuthenticationType) {
        if (identifier == null) {
            return defaultAuthenticationType;
        }
        try {
            return AuthenticationType.ofIdentifier(identifier);
        }
        catch (IllegalArgumentException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(AuthenticationType.class.getSimpleName() + " '" + identifier + "' is not supported. Falling back to " + (Object)((Object)defaultAuthenticationType) + ".");
            }
            return defaultAuthenticationType;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    static {
        logger = CloudLoggerFactory.getLogger(AuthenticationType.class);
    }
}

