/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.json.JsonSanitizer;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationFacade;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.EnvironmentVariableDestinationParser;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.RfcDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public abstract class AbstractDestinationFacade
implements DestinationFacade {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractDestinationFacade.class);
    static final String VARIABLE_DESTINATIONS = "destinations";

    @Nullable
    String getEnvironmentVariable(@Nonnull String name) {
        return System.getenv(name);
    }

    @Nullable
    protected Map<String, JsonObject> getDestinationsFromEnvironmentVariable() throws DestinationAccessException {
        JsonArray jsonArray;
        String destinations = this.getEnvironmentVariable(VARIABLE_DESTINATIONS);
        if (Strings.isNullOrEmpty((String)destinations)) {
            return null;
        }
        try {
            jsonArray = new JsonParser().parse(JsonSanitizer.sanitize((String)destinations)).getAsJsonArray();
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new DestinationAccessException("Failed to parse environment variable 'destinations'. Make sure to define this variable as a JSON array that contains a JSON object for each destination.", e);
        }
        HashMap<String, JsonObject> result = new HashMap<String, JsonObject>();
        for (JsonElement jsonElement : jsonArray) {
            if (jsonElement == null || !jsonElement.isJsonObject()) {
                throw new DestinationAccessException("Destination is not a JSON object.");
            }
            JsonObject destinationAsJson = jsonElement.getAsJsonObject();
            EnvironmentVariableDestinationParser destinationParser = new EnvironmentVariableDestinationParser(destinationAsJson);
            result.put(destinationParser.getName(), destinationAsJson);
        }
        return result;
    }

    @Nonnull
    protected Map<String, GenericDestination> getDestinationsFromEnvironmentVariable(DestinationFactory destinationFactory) throws DestinationAccessException {
        Map<String, JsonObject> destinationsByName = this.getDestinationsFromEnvironmentVariable();
        if (destinationsByName == null) {
            throw new DestinationAccessException("Failed to get destinations from environment variable 'destinations'. Make sure to define this variable as a JSON array that contains a JSON object for each destination.");
        }
        HashMap<String, GenericDestination> result = new HashMap<String, GenericDestination>();
        for (Map.Entry<String, JsonObject> entry : destinationsByName.entrySet()) {
            String name = entry.getKey();
            JsonObject destinationAsJson = entry.getValue();
            EnvironmentVariableDestinationParser destinationParser = new EnvironmentVariableDestinationParser(destinationAsJson);
            result.put(name, destinationFactory.create(destinationParser));
        }
        return result;
    }

    @Override
    public void declareDestinations(@Nonnull Collection<String> destinationNames) {
    }

    @Override
    @Nonnull
    public DestinationType getDestinationType(@Nonnull String destinationName) throws DestinationNotFoundException, DestinationAccessException {
        return this.getGenericDestination(destinationName).getDestinationType();
    }

    @Override
    @Nonnull
    public GenericDestination getGenericDestination(@Nonnull String destinationName) throws DestinationNotFoundException, DestinationAccessException {
        GenericDestination destination = this.getGenericDestinationsByName().get(destinationName);
        if (destination == null) {
            throw new DestinationNotFoundException(destinationName);
        }
        return destination;
    }

    @Override
    @Nonnull
    public Destination getDestination(@Nonnull String destinationName) throws DestinationNotFoundException, DestinationAccessException {
        GenericDestination destination = this.getGenericDestination(destinationName);
        this.assertDestinationType(destination, DestinationType.HTTP);
        return (Destination)destination;
    }

    @Override
    @Nonnull
    public RfcDestination getRfcDestination(@Nonnull String destinationName) throws DestinationNotFoundException, DestinationAccessException {
        GenericDestination destination = this.getGenericDestination(destinationName);
        this.assertDestinationType(destination, DestinationType.RFC);
        return (RfcDestination)destination;
    }

    protected void assertDestinationType(@Nonnull GenericDestination destination, @Nonnull DestinationType expectedType) throws DestinationAccessException {
        DestinationType actualType = destination.getDestinationType();
        if (expectedType != actualType) {
            throw new DestinationAccessException("Destination '" + destination.getName() + "' is not of type " + (Object)((Object)expectedType) + ". Actual type: " + (Object)((Object)actualType) + ".");
        }
    }

    @Nonnull
    protected <DestinationT extends GenericDestination> Map<String, DestinationT> getDestinationsForType(@Nonnull DestinationType destinationType) {
        Map<String, GenericDestination> destinations = this.getGenericDestinationsByName();
        HashMap<String, GenericDestination> result = new HashMap<String, GenericDestination>();
        for (GenericDestination destination : destinations.values()) {
            if (destinationType == destination.getDestinationType()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Adding " + (Object)((Object)destinationType) + " destination to result.");
                }
                GenericDestination dest = destination;
                result.put(destination.getName(), dest);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Omitting non-" + (Object)((Object)destinationType) + " destination.");
        }
        return result;
    }

    @Override
    @Nonnull
    public Map<String, Destination> getDestinationsByName() throws DestinationAccessException {
        return this.getDestinationsForType(DestinationType.HTTP);
    }

    @Override
    @Nonnull
    public Map<String, RfcDestination> getRfcDestinationsByName() throws DestinationAccessException {
        return this.getDestinationsForType(DestinationType.RFC);
    }
}

