/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;

@WebListener
public class DestinationsRequestContextListener
implements RequestContextListener,
ServletContextListener {
    private static final Logger logger = CloudLoggerFactory.getLogger(DestinationsRequestContextListener.class);
    public static final String PROPERTY_HTTP_CLIENTS = DestinationsRequestContextListener.class.getName() + ":httpClients";

    public int getPriority() {
        return -2147483647;
    }

    public void requestContextInitialized(RequestContext requestContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking requestContextInitialized().");
        }
        requestContext.setPropertyIfAbsent(PROPERTY_HTTP_CLIENTS, (Object)CacheBuilder.newBuilder().concurrencyLevel(10).build());
    }

    public void requestContextDestroyed(RequestContext requestContext) {
        Cache cache;
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking requestContextDestroyed().");
        }
        if ((cache = (Cache)requestContext.removeProperty(PROPERTY_HTTP_CLIENTS).orNull()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalidating " + HttpClient.class.getSimpleName() + " cache.");
            }
            cache.invalidateAll();
            cache.cleanUp();
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        RequestContextServletFilter.addDefaultListener((RequestContextListener)this);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        RequestContextServletFilter.removeDefaultListener((RequestContextListener)this);
    }
}

