/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationFacade;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.RfcDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;

public final class DestinationAccessor {
    @Nullable
    private static DestinationFacade destinationFacade = (DestinationFacade)FacadeLocator.getFacade(DestinationFacade.class);

    private static DestinationFacade facade() throws ShouldNotHappenException {
        DestinationFacade destinationFacade = DestinationAccessor.destinationFacade;
        if (destinationFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform while accessing destination information. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SCP Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SCP Neo. Within tests, make sure to declare \"private static final MockUtil mockUtil = new MockUtil()\" in your test class and invoke \"mockUtil.mockDefaults()\" before running the tests.");
        }
        return destinationFacade;
    }

    public static void setDestinationFacade(DestinationFacade destinationFacade) {
        DestinationAccessor.destinationFacade = destinationFacade;
    }

    public static void declareDestinations(String ... destinationNames) {
        DestinationAccessor.declareDestinations(Arrays.asList(destinationNames));
    }

    public static void declareDestinations(Collection<String> destinationNames) {
        DestinationAccessor.facade().declareDestinations(destinationNames);
    }

    public static DestinationType getDestinationType(String destinationName) throws DestinationNotFoundException, DestinationAccessException {
        return DestinationAccessor.facade().getDestinationType(destinationName);
    }

    public static GenericDestination getGenericDestination(String destinationName) throws DestinationNotFoundException, DestinationAccessException {
        return DestinationAccessor.facade().getGenericDestination(destinationName);
    }

    public static Destination getDestination(String destinationName) throws DestinationNotFoundException, DestinationAccessException {
        return DestinationAccessor.facade().getDestination(destinationName);
    }

    public static RfcDestination getRfcDestination(String destinationName) throws DestinationNotFoundException, DestinationAccessException {
        return DestinationAccessor.facade().getRfcDestination(destinationName);
    }

    public static Map<String, ? extends GenericDestination> getGenericDestinationsByName() throws DestinationAccessException {
        return DestinationAccessor.facade().getGenericDestinationsByName();
    }

    public static Map<String, Destination> getDestinationsByName() throws DestinationAccessException {
        return DestinationAccessor.facade().getDestinationsByName();
    }

    public static Map<String, RfcDestination> getRfcDestinationsByName() throws DestinationAccessException {
        return DestinationAccessor.facade().getRfcDestinationsByName();
    }

    @Nullable
    public static DestinationFacade getDestinationFacade() {
        return destinationFacade;
    }
}

