/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.cache;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.cache.UnmergeableCacheKeyException;
import com.sap.cloud.sdk.cloudplatform.security.user.UserAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;

public class CacheKey {
    @Nullable
    private final String tenantId;
    @Nullable
    private final String userName;
    private final ArrayList<Object> components = Lists.newArrayList();

    public Optional<String> getTenantId() {
        return Optional.fromNullable((Object)this.tenantId);
    }

    public Optional<String> getUserName() {
        return Optional.fromNullable((Object)this.userName);
    }

    private CacheKey(@Nullable String tenantId, @Nullable String userName) {
        this.tenantId = tenantId;
        this.userName = userName;
    }

    private void assertAppendable(CacheKey other) throws IllegalArgumentException, UnmergeableCacheKeyException {
        if (other == null) {
            throw new IllegalArgumentException("Cache key must not be null.");
        }
        if (this.tenantId != null && !this.tenantId.equals(other.tenantId)) {
            throw new UnmergeableCacheKeyException("Cannot merge CacheKey with tenant " + other.tenantId + " into CacheKey with different tenant " + this.tenantId + ".", this, other);
        }
        if (this.userName != null && !this.userName.equals(other.userName)) {
            throw new UnmergeableCacheKeyException("Cannot merge CacheKey with user " + other.userName + " into CacheKey with different user " + this.userName + ".", this, other);
        }
    }

    private static String getCurrentTenantId() {
        return TenantAccessor.getCurrentTenant().getTenantId();
    }

    private static String getCurrentUserName() {
        return UserAccessor.getCurrentUser().getName();
    }

    public CacheKey append(CacheKey other, Object ... objects) throws IllegalArgumentException, UnmergeableCacheKeyException {
        this.assertAppendable(other);
        this.components.addAll(other.components);
        Collections.addAll(this.components, objects);
        return this;
    }

    public CacheKey append(@Nullable Object object, Object ... objects) {
        this.components.add(object);
        Collections.addAll(this.components, objects);
        return this;
    }

    public static CacheKey newGlobalKey(CacheKey cacheKey) throws IllegalArgumentException {
        return CacheKey.newGlobalKey().append(cacheKey, new Object[0]);
    }

    public static CacheKey newGlobalKey() {
        return new CacheKey(null, null);
    }

    public static CacheKey newTenantIsolatedKey(String tenantId) throws IllegalArgumentException {
        if (tenantId == null) {
            throw new IllegalArgumentException("Tenant identifier must not be null.");
        }
        return new CacheKey(tenantId, null);
    }

    public static CacheKey newTenantIsolatedKey() throws IllegalArgumentException {
        return CacheKey.newTenantIsolatedKey(CacheKey.getCurrentTenantId());
    }

    public static CacheKey newTenantIsolatedKey(CacheKey cacheKey, String tenantId) throws IllegalArgumentException {
        return CacheKey.newTenantIsolatedKey(tenantId).append(cacheKey, new Object[0]);
    }

    public static CacheKey newTenantIsolatedKey(CacheKey cacheKey) throws IllegalArgumentException {
        return CacheKey.newTenantIsolatedKey().append(cacheKey, new Object[0]);
    }

    public static CacheKey newUserIsolatedKey(String tenantId, String userName) throws IllegalArgumentException {
        if (tenantId == null) {
            throw new IllegalArgumentException("Tenant identifier must not be null.");
        }
        if (userName == null) {
            throw new IllegalArgumentException("User name must not be null.");
        }
        return new CacheKey(tenantId, userName);
    }

    public static CacheKey newUserIsolatedKey(String userName) throws IllegalArgumentException {
        return CacheKey.newUserIsolatedKey(CacheKey.getCurrentTenantId(), userName);
    }

    public static CacheKey newUserIsolatedKey() {
        return CacheKey.newUserIsolatedKey(CacheKey.getCurrentTenantId(), CacheKey.getCurrentUserName());
    }

    public static CacheKey newUserIsolatedKey(CacheKey cacheKey, String tenantId, String userName) throws IllegalArgumentException {
        return CacheKey.newUserIsolatedKey(tenantId, userName).append(cacheKey, new Object[0]);
    }

    public static CacheKey newUserIsolatedKey(CacheKey cacheKey, String userName) throws IllegalArgumentException {
        return CacheKey.newUserIsolatedKey(userName).append(cacheKey, new Object[0]);
    }

    public static CacheKey newUserIsolatedKey(CacheKey cacheKey) throws IllegalArgumentException {
        return CacheKey.newUserIsolatedKey().append(cacheKey, new Object[0]);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheKey)) {
            return false;
        }
        CacheKey other = (CacheKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<String> this$tenantId = this.getTenantId();
        Optional<String> other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        Optional<String> this$userName = this.getUserName();
        Optional<String> other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        ArrayList<Object> this$components = this.getComponents();
        ArrayList<Object> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        Optional<String> $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        ArrayList<Object> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    public String toString() {
        return "CacheKey(tenantId=" + this.getTenantId() + ", userName=" + this.getUserName() + ", components=" + this.getComponents() + ")";
    }

    public ArrayList<Object> getComponents() {
        return this.components;
    }
}

