/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.auditlog;

import com.google.common.base.Strings;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessRequester;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessedAttribute;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLog;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public final class DefaultLoggerAuditLog
implements AuditLog {
    private static final Logger logger = CloudLoggerFactory.getLogger(DefaultLoggerAuditLog.class);
    private static final String ACTION_BEGINNING = "[BEGINNING] ";
    private static final String ACTION_COMPLETED = "[COMPLETED] ";
    private static final String ACTION_FAILED = "[FAILED] ";

    private void logToLocal(boolean isBeginning, @Nonnull String topic, @Nullable String message, @Nullable String info, @Nullable Throwable e) {
        if (e != null || logger.isInfoEnabled()) {
            String printableMessage = StringUtils.join((Object[])new String[]{message, info}, (String)" | ");
            if (e == null) {
                String phase = isBeginning ? ACTION_BEGINNING : ACTION_COMPLETED;
                logger.info(topic + phase + printableMessage);
            } else {
                logger.error(topic + ACTION_FAILED + printableMessage, e);
            }
        }
    }

    private void attributesToLogItems(Iterable<AccessedAttribute> attributes, ArrayList<String> infoItems) {
        if (attributes != null) {
            ArrayList<String> changes = new ArrayList<String>();
            for (AccessedAttribute attribute : attributes) {
                changes.add(attribute.getIdentifier() + "(\"" + String.valueOf(attribute.getOldValue()) + "\" -> \"" + String.valueOf(attribute.getNewValue()) + "\")");
            }
            infoItems.add("[ " + StringUtils.join(changes, (String)", ") + " ]");
        }
    }

    private void logSecurityEvent(boolean isBeginning, AccessRequester initiator, String message, @Nullable Throwable error) {
        String info = null;
        if (initiator != null) {
            info = ((String)initiator.getIpAddress().or((Object)"") + " " + (String)initiator.getUserId().or((Object)"")).trim();
        }
        this.logToLocal(isBeginning, "[SECURITY] ", message, info, error);
    }

    private void logConfigChange(boolean isBeginning, AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        ArrayList<String> infoItems = new ArrayList<String>();
        if (initiator != null) {
            infoItems.add(((String)initiator.getIpAddress().or((Object)"") + " " + (String)initiator.getUserId().or((Object)"")).trim());
        }
        if (!Strings.isNullOrEmpty((String)objectId)) {
            infoItems.add(objectId);
        }
        this.attributesToLogItems(attributesAffected, infoItems);
        String info = StringUtils.join(infoItems, (String)" - ");
        this.logToLocal(isBeginning, "[CONFIG] ", message, info, error);
    }

    private void logDataRead(boolean isBeginning, AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        ArrayList<String> infoItems = new ArrayList<String>();
        if (initiator != null && initiator.getChannel().isPresent()) {
            infoItems.add((String)initiator.getChannel().get());
        }
        if (!Strings.isNullOrEmpty((String)objectId)) {
            infoItems.add(objectId);
        }
        this.attributesToLogItems(attributesAffected, infoItems);
        String info = StringUtils.join(infoItems, (String)" - ");
        this.logToLocal(isBeginning, "[DATA-READ] ", message, info, error);
    }

    private void logDataWrite(boolean isBeginning, AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        ArrayList<String> infoItems = new ArrayList<String>();
        if (!Strings.isNullOrEmpty((String)objectId)) {
            infoItems.add(objectId);
        }
        this.attributesToLogItems(attributesAffected, infoItems);
        String info = StringUtils.join(infoItems, (String)" - ");
        this.logToLocal(isBeginning, "[DATA-WRITE] ", message, info, error);
    }

    @Override
    public void logSecurityEventBeginning(AccessRequester initiator, String message) {
        this.logSecurityEvent(true, initiator, message, null);
    }

    @Override
    public void logSecurityEvent(AccessRequester initiator, String message, @Nullable Throwable throwable) {
        this.logSecurityEvent(false, initiator, message, throwable);
    }

    @Override
    public void logConfigChangeBeginning(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message) {
        this.logConfigChange(true, initiator, objectId, objectName, attributesAffected, message, null);
    }

    @Override
    public void logConfigChange(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        this.logConfigChange(false, initiator, objectId, objectName, attributesAffected, message, error);
    }

    @Override
    public void logDataReadAttempt(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message) {
        this.logDataRead(true, initiator, objectId, objectName, attributesAffected, message, null);
    }

    @Override
    public void logDataRead(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        this.logDataRead(false, initiator, objectId, objectName, attributesAffected, message, error);
    }

    @Override
    public void logDataWriteAttempt(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message) {
        this.logDataWrite(true, initiator, objectId, objectName, attributesAffected, message, null);
    }

    @Override
    public void logDataWrite(AccessRequester initiator, String objectId, @Nullable String objectName, @Nullable Iterable<AccessedAttribute> attributesAffected, @Nullable String message, @Nullable Throwable error) {
        this.logDataWrite(false, initiator, objectId, objectName, attributesAffected, message, error);
    }
}

