/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd.mojo;

import com.sap.core.sdk.cmd.mojo.AbstractConsoleCommandMojo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="help", requiresProject=false, threadSafe=true)
public class HelpMojo
extends AbstractMojo {
    static final String LINE_ENDING = String.format("%n", new Object[0]).intern();
    @Parameter(property="goal", readonly=false, required=false)
    public String goal;
    @Parameter(property="details", defaultValue="false", readonly=false, required=false)
    public boolean details;
    @Parameter(property="all", defaultValue="false", readonly=false, required=false)
    private boolean all;
    @Parameter(defaultValue="${mojoExecution}", readonly=true, required=true)
    private MojoExecution mojoExecution;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Help help = new Help();
        Map<String, MojoData> mojos = HelpMojo.readData(this.mojoExecution.getMojoDescriptor().getPluginDescriptor());
        if (AbstractConsoleCommandMojo.isSet(this.goal)) {
            MojoData mojo = mojos.get(this.goal);
            if (mojo != null) {
                help.appendLine("Help for goal " + this.goal + ":");
                help.appendLine();
                this.details = true;
                HelpMojo.appendMojoHelp(help, mojo, this.details, this.all);
            } else {
                help.appendLine("Help for goal " + this.goal + " not found.");
                help.appendLine();
                HelpMojo.appendGeneralUsage(help);
            }
        } else {
            help.appendLine("Help for all goals:");
            help.appendLine();
            ArrayList<MojoData> mojosSorted = new ArrayList<MojoData>(mojos.values());
            Collections.sort(mojosSorted);
            for (MojoData mojo : mojosSorted) {
                HelpMojo.appendMojoHelp(help, mojo, this.details, this.all);
            }
            HelpMojo.appendGeneralUsage(help);
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)help.getContent());
        }
    }

    static Map<String, MojoData> readData(PluginDescriptor pluginDescriptor) {
        HashMap<String, MojoData> mojos = new HashMap<String, MojoData>();
        for (MojoDescriptor mojoDescriptor : pluginDescriptor.getMojos()) {
            MojoData mojo = new MojoData();
            mojo.setGoal(mojoDescriptor.getGoal());
            mojo.setCommand(HelpMojo.extractLastWord(mojoDescriptor.getDescription()));
            mojo.setDescription(mojo.getCommand() != null ? HelpMojo.extractAllButLastSentence(mojoDescriptor.getDescription()) : mojoDescriptor.getDescription());
            for (org.apache.maven.plugin.descriptor.Parameter parameterDescriptor : mojoDescriptor.getParameters()) {
                if (!parameterDescriptor.isEditable()) continue;
                ParameterData parameter = new ParameterData();
                parameter.setName(AbstractConsoleCommandMojo.isSet(parameterDescriptor.getAlias()) ? parameterDescriptor.getAlias() : parameterDescriptor.getName());
                parameter.setField(parameterDescriptor.getName());
                parameter.setArgument(HelpMojo.extractLastWord(parameterDescriptor.getDescription()));
                parameter.setDescription(parameter.getArgument() != null ? HelpMojo.extractAllButLastSentence(parameterDescriptor.getDescription()) : parameterDescriptor.getDescription());
                parameter.setRequired(parameterDescriptor.isRequired());
                parameter.setHidden(HelpMojo.isHidden(mojoDescriptor, parameterDescriptor));
                mojo.addParameter(parameter);
            }
            Collections.sort(mojo.getParameters());
            mojos.put(mojo.getGoal(), mojo);
        }
        return mojos;
    }

    static boolean isHidden(MojoDescriptor mojo, org.apache.maven.plugin.descriptor.Parameter parameter) {
        try {
            Field parameterField = null;
            for (Class<?> mojoClass = Class.forName(mojo.getImplementation()); mojoClass != null; mojoClass = mojoClass.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = mojoClass.getDeclaredFields()) {
                    if (!field.getName().equals(parameter.getName())) continue;
                    parameterField = field;
                }
            }
            if (parameterField != null) {
                return (parameterField.getModifiers() & 1) == 0;
            }
            throw new RuntimeException("Mojo class field not found although mojo parameter is listed in plugin descriptor.");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Mojo class not found although mojo is listed in plugin descriptor.");
        }
    }

    static void appendMojoHelp(Help help, MojoData mojo, boolean details, boolean all) {
        help.appendLine("  Goal:        " + mojo.getGoal() + (mojo.getCommand() != null ? " (maps to console client command " + mojo.getCommand() + ")" : " (general goal)"));
        if (AbstractConsoleCommandMojo.isSet(mojo.getDescription())) {
            help.appendLine("  Description: " + HelpMojo.splitAndIndent(mojo.getDescription(), 15, 80));
        }
        help.appendLine();
        if (details || all) {
            for (ParameterData parameter : mojo.getParameters()) {
                if (parameter.isHidden() && !all) continue;
                help.appendLine("    Parameter:   " + parameter.getName() + (parameter.getArgument() != null ? " (maps to console client command argument " + parameter.getArgument() + ")" : (mojo.getCommand() != null ? " (general parameter)" : "")));
                if (AbstractConsoleCommandMojo.isSet(parameter.getDescription())) {
                    help.appendLine("    Description: " + HelpMojo.splitAndIndent(parameter.getDescription(), 17, 80));
                }
                if (parameter.isRequired()) {
                    help.appendLine("    Required:    Yes");
                }
                help.appendLine();
            }
        }
    }

    static void appendGeneralUsage(Help help) {
        help.appendLine("Usage: This plugin executes commands in the console client (neo) of the");
        help.appendLine("SAP BTP SDK for the Neo environment. All commands have goals with the same names.");
        help.appendLine("Their arguments can be supplied as configuration parameters and have similar names");
        help.appendLine("as in the console client (parameters are in camel case and have no dashes).");
        help.appendLine("Alternatively you can use the goals run-console-command or run-console-commands,");
        help.appendLine("which are more compact as you can put the command and its arguments in one line.");
        help.appendLine("These goals will also include arguments provided by the plugin configuration.");
    }

    static String extractAllButLastSentence(String text) {
        int index = (text = text.trim()).lastIndexOf(" Maps to console client command ");
        if (index != -1) {
            return text.substring(0, index).trim();
        }
        return null;
    }

    static String extractLastWord(String text) {
        int index = (text = text.trim()).lastIndexOf(" Maps to console client command ");
        if (index != -1) {
            return text.substring(text.lastIndexOf(" ") + 1, text.lastIndexOf(".")).trim();
        }
        return null;
    }

    static String formatDescription(String description) {
        if (description == null || description.length() == 0) {
            return "";
        }
        description = description.replaceAll("\r\n|\r|\n", " ").replaceAll("\\s+", " ").trim();
        return description.replaceAll("&#47;", "/").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    }

    static String splitAndIndent(String line, int indentation, int lineLength) {
        StringBuilder buffer = new StringBuilder();
        lineLength -= indentation;
        while (line != null) {
            if ((line = line.trim()).length() > lineLength) {
                int splitIndex = line.lastIndexOf(32, lineLength);
                if (splitIndex == -1) {
                    splitIndex = line.indexOf(32, lineLength);
                }
                if (splitIndex == -1) {
                    buffer.append(line);
                    line = null;
                    continue;
                }
                buffer.append(line.substring(0, splitIndex));
                buffer.append(LINE_ENDING);
                for (int i = 0; i < indentation; ++i) {
                    buffer.append(' ');
                }
                line = line.substring(splitIndex + 1);
                continue;
            }
            buffer.append(line);
            line = null;
        }
        return buffer.toString();
    }

    static class ParameterData
    implements Comparable<ParameterData> {
        private String name;
        private String field;
        private String argument;
        private String description;
        private boolean required;
        private boolean hidden;

        ParameterData() {
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        void setField(String field) {
            this.field = field;
        }

        String getArgument() {
            return this.argument;
        }

        void setArgument(String argument) {
            this.argument = argument;
        }

        String getDescription() {
            return this.description;
        }

        void setDescription(String description) {
            this.description = HelpMojo.formatDescription(description);
        }

        boolean isRequired() {
            return this.required;
        }

        void setRequired(boolean required) {
            this.required = required;
        }

        boolean isHidden() {
            return this.hidden;
        }

        void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        @Override
        public int compareTo(ParameterData parameter) {
            return this.field.compareTo(parameter.field);
        }
    }

    static class MojoData
    implements Comparable<MojoData> {
        private String goal;
        private String command;
        private String description;
        private List<ParameterData> parameters = new ArrayList<ParameterData>();

        MojoData() {
        }

        String getGoal() {
            return this.goal;
        }

        void setGoal(String goal) {
            this.goal = goal;
        }

        String getCommand() {
            return this.command;
        }

        void setCommand(String command) {
            this.command = command;
        }

        String getDescription() {
            return this.description;
        }

        void setDescription(String description) {
            this.description = HelpMojo.formatDescription(description);
        }

        List<ParameterData> getParameters() {
            return this.parameters;
        }

        void addParameter(ParameterData parameter) {
            this.parameters.add(parameter);
        }

        @Override
        public int compareTo(MojoData mojo) {
            return this.goal.compareTo(mojo.goal);
        }
    }

    static class Help {
        private StringBuilder buffer = new StringBuilder();

        Help() {
        }

        void appendLine(String line) {
            this.buffer.append(line);
            this.buffer.append(LINE_ENDING);
        }

        void appendLine() {
            this.appendLine("");
        }

        String getContent() {
            return this.buffer.toString();
        }
    }
}

