/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;

public class SdkVersion {
    public static boolean isPresent(File sdkInstallPath) {
        return new File(sdkInstallPath, "sdk.version").exists();
    }

    public static String read(File sdkInstallPath) {
        String version = null;
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(sdkInstallPath, "sdk.version"));
            Properties properties = new Properties();
            properties.load(inputStream);
            version = properties.getProperty("release.version");
        }
        catch (FileNotFoundException exception) {
            String string = null;
            return string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to read version information for SDK in " + sdkInstallPath + ".");
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (version == null) {
            throw new RuntimeException("No version information found for SDK in " + sdkInstallPath + ".");
        }
        return version.trim();
    }
}

