/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.sdk.cmd.mojo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.maven.plugin.logging.Log;

class StreamReader
extends Thread {
    private static final String LINE_ENDING = String.format("%n", new Object[0]).intern();
    private final InputStream inStream;
    private final TYPE type;
    private final StringBuilder buffer;
    private final Log log;
    private Exception readException;

    StreamReader(InputStream inStream) {
        this(inStream, TYPE.BUFFER, null);
    }

    StreamReader(InputStream inStream, TYPE type, Log log) {
        this.inStream = inStream;
        this.type = type;
        this.buffer = new StringBuilder();
        this.log = log;
        this.readException = null;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inStream));
        try {
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                this.handleLine(line);
            }
        }
        catch (IOException exception) {
            this.readException = exception;
            this.handleLine(LINE_ENDING + "Error while reading: " + exception.toString());
        }
    }

    private synchronized void handleLine(String line) {
        switch (this.type) {
            case BUFFER: {
                this.buffer.append(line);
                this.buffer.append(LINE_ENDING);
                break;
            }
            case LOG_AS_INFO: {
                this.log.info((CharSequence)line);
                break;
            }
            case LOG_AS_ERROR: {
                this.log.error((CharSequence)line);
            }
        }
    }

    String getBuffer() {
        return this.buffer.toString();
    }

    Exception getReadException() {
        return this.readException;
    }

    static enum TYPE {
        BUFFER,
        LOG_AS_INFO,
        LOG_AS_ERROR;

    }
}

