/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.environment.servicebinding.api;

import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.environment.servicebinding.api.ServiceBindingAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public class ServiceBindingMerger
implements ServiceBindingAccessor {
    @Nonnull
    public static final EqualityComparer KEEP_EVERYTHING = (a, b) -> false;
    @Nonnull
    public static final EqualityComparer KEEP_UNIQUE = Object::equals;
    @Nonnull
    private final Collection<ServiceBindingAccessor> accessors;
    @Nonnull
    private final EqualityComparer equalityComparer;

    public ServiceBindingMerger(@Nonnull Collection<ServiceBindingAccessor> accessors, @Nonnull EqualityComparer equalityComparer) {
        this.accessors = new ArrayList<ServiceBindingAccessor>(accessors);
        this.equalityComparer = equalityComparer;
    }

    @Override
    @Nonnull
    public List<ServiceBinding> getServiceBindings() {
        ArrayList<ServiceBinding> mergedServiceBindings = new ArrayList<ServiceBinding>();
        this.accessors.stream().map(ServiceBindingAccessor::getServiceBindings).flatMap(Collection::stream).forEachOrdered(binding -> {
            if (this.contains((List<ServiceBinding>)mergedServiceBindings, (ServiceBinding)binding)) {
                return;
            }
            mergedServiceBindings.add((ServiceBinding)binding);
        });
        return mergedServiceBindings;
    }

    private boolean contains(@Nonnull List<ServiceBinding> existingBindings, @Nonnull ServiceBinding newBinding) {
        return existingBindings.stream().anyMatch(contained -> this.equalityComparer.areEqual((ServiceBinding)contained, newBinding));
    }

    @FunctionalInterface
    public static interface EqualityComparer {
        public boolean areEqual(@Nonnull ServiceBinding var1, @Nonnull ServiceBinding var2);
    }
}

