/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@NotThreadSafe
public class TraceConfiguration {
    public static final long MINIMUM_TRACE_SIZE = 8192L;
    public static final long UNLIMITED_TRACE_SIZE = Long.MAX_VALUE;
    static final String DEFAULT_TRACE_FILE_PATH = "jdbctrace.prt";
    static final String DEFAULT_PERFORMANCE_TRACE_FILE_PATH = "jdbcperformancetrace.prt";
    private static final String SETTINGS_FILE_NAME = "jdbctracesettings.ini";
    private static final String SHARED_MEMORY_FILE_NAME = "jdbctrace.shm";
    private static final String TRACE_ENABLED = "TRACE ENABLED";
    private static final String TRACE_FILE = "TRACE FILE";
    private static final String SHOW_PLAINTEXTCSE = "SHOW PLAINTEXTCSE";
    private static final String SHOW_TIMESTAMPS = "SHOW TIMESTAMPS";
    private static final String TRACE_SIZE = "TRACE SIZE";
    private static final String STOP_ON_ERROR = "STOP ON ERROR";
    private static final String PERFORMANCE_TRACE_ENABLED = "PERFORMANCE TRACE ENABLED";
    private static final String PERFORMANCE_TRACE_FILE = "PERFORMANCE TRACE FILE";
    private static final String CONFIG_DIRECTORY_NAME;
    private boolean _isTraceEnabled;
    private String _traceFileName;
    private Set<TraceLevel> _traceLevels;
    private boolean _isShowPlainTextCSEEnabled;
    private boolean _isShowTimestampsEnabled;
    private long _traceSize;
    private int _stopOnError;
    private boolean _isPerformanceTraceEnabled;
    private String _performanceTraceFileName;
    private MappedByteBuffer _shmem;
    private boolean _isShmemAttached;
    private boolean _isShmemAttachFailed;
    private long _traceSwitchCount;

    static String getConfigDirectoryName() {
        return CONFIG_DIRECTORY_NAME;
    }

    static String getSettingsFileName() {
        return CONFIG_DIRECTORY_NAME + SETTINGS_FILE_NAME;
    }

    static String getSharedMemoryFileName() {
        return CONFIG_DIRECTORY_NAME + SHARED_MEMORY_FILE_NAME;
    }

    public TraceConfiguration() {
        this.initTraceSettings(true);
        this.loadTraceSettings();
        this._attach();
    }

    public TraceConfiguration(String traceFileName, String traceOptions) {
        this.initTraceSettings(false);
        this._traceFileName = traceFileName;
        this._parseTraceOptions(traceOptions);
    }

    public boolean isTraceEnabled() {
        return this._isTraceEnabled;
    }

    public void setTraceEnabled(boolean isTraceEnabled) {
        this._isTraceEnabled = isTraceEnabled;
    }

    public String getTraceFileName() {
        return this._traceFileName;
    }

    public void setTraceFileName(String traceFileName) {
        this._traceFileName = traceFileName;
    }

    public boolean hasTraceLevel(TraceLevel traceLevel) {
        return this._traceLevels.contains((Object)traceLevel);
    }

    public void setTraceLevel(TraceLevel traceLevel, boolean enable) {
        if (enable) {
            this._traceLevels.add(traceLevel);
        } else {
            this._traceLevels.remove((Object)traceLevel);
        }
    }

    public boolean isShowPlainTextCSEEnabled() {
        return this._isShowPlainTextCSEEnabled;
    }

    public void setShowPlainTextCSEEnabled(boolean isShowPlainTextCSEEnabled) {
        this._isShowPlainTextCSEEnabled = isShowPlainTextCSEEnabled;
    }

    public boolean isShowTimestampsEnabled() {
        return this._isShowTimestampsEnabled;
    }

    public void setShowTimestampsEnabled(boolean isShowTimestampsEnabled) {
        this._isShowTimestampsEnabled = isShowTimestampsEnabled;
    }

    public long getTraceSize() {
        return this._traceSize;
    }

    public String getDisplayTraceSize() {
        return SizeUnits.getDisplaySize(this._traceSize);
    }

    public String getDisplayTraceSizeUnits() {
        return SizeUnits.getDisplayUnits(this._traceSize);
    }

    public void setTraceSize(long size, String units) {
        long traceSize = SizeUnits.getSizeWithoutUnits(size, units);
        if (traceSize < 8192L) {
            traceSize = 8192L;
        }
        this._traceSize = traceSize;
    }

    public int getStopOnError() {
        return this._stopOnError;
    }

    public void setStopOnError(int stopOnError) {
        this._stopOnError = stopOnError;
    }

    public boolean isPerformanceTraceEnabled() {
        return this._isPerformanceTraceEnabled;
    }

    public void setPerformanceTraceEnabled(boolean isPerformanceTraceEnabled) {
        this._isPerformanceTraceEnabled = isPerformanceTraceEnabled;
    }

    public String getPerformanceTraceFileName() {
        return this._performanceTraceFileName;
    }

    public void setPerformanceTraceFileName(String performanceTraceFileName) {
        this._performanceTraceFileName = performanceTraceFileName;
    }

    public boolean isShmemAttached() {
        return this._isShmemAttached;
    }

    public boolean isShmemAttachFailed() {
        return this._isShmemAttachFailed;
    }

    public boolean hasTraceSettingsChanged() {
        if (this._shmem == null) {
            return false;
        }
        long newVal = this._shmem.getLong(0);
        if (this._traceSwitchCount != newVal) {
            this._traceSwitchCount = newVal;
            return true;
        }
        return false;
    }

    public void setTraceSettingsChanged() {
        if (this._shmem == null) {
            return;
        }
        this._shmem.putLong(0, ++this._traceSwitchCount);
        this._shmem.force();
    }

    public void initTraceSettings(boolean enableDefaults) {
        this._isTraceEnabled = false;
        this._traceFileName = DEFAULT_TRACE_FILE_PATH;
        this._traceLevels = EnumSet.noneOf(TraceLevel.class);
        if (enableDefaults) {
            this._traceLevels.add(TraceLevel.CONNECTIONS);
            this._traceLevels.add(TraceLevel.API);
            this._traceLevels.add(TraceLevel.PACKET);
        }
        this._isShowPlainTextCSEEnabled = false;
        this._isShowTimestampsEnabled = false;
        this._traceSize = Long.MAX_VALUE;
        this._stopOnError = 0;
        this._isPerformanceTraceEnabled = false;
        this._performanceTraceFileName = DEFAULT_PERFORMANCE_TRACE_FILE_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTraceSettings() {
        File file = new File(TraceConfiguration.getSettingsFileName());
        Properties properties = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            properties.load(stream);
            this._isTraceEnabled = properties.getProperty(TRACE_ENABLED, "OFF").equals("ON");
            this._traceFileName = properties.getProperty(TRACE_FILE, DEFAULT_TRACE_FILE_PATH);
            for (TraceLevel traceLevel : TraceLevel.values()) {
                this.setTraceLevel(traceLevel, properties.getProperty(traceLevel._propertyName, "1").equals("1"));
            }
            this._isShowPlainTextCSEEnabled = properties.getProperty(SHOW_PLAINTEXTCSE, "OFF").equals("ON");
            this._isShowTimestampsEnabled = properties.getProperty(SHOW_TIMESTAMPS, "OFF").equals("ON");
            try {
                this._traceSize = Long.parseLong(properties.getProperty(TRACE_SIZE, String.valueOf(Long.MAX_VALUE)));
            }
            catch (NumberFormatException e) {
                this._traceSize = Long.MAX_VALUE;
            }
            this._stopOnError = Integer.parseInt(properties.getProperty(STOP_ON_ERROR, "0"));
            this._isPerformanceTraceEnabled = properties.getProperty(PERFORMANCE_TRACE_ENABLED, "OFF").equals("ON");
            this._performanceTraceFileName = properties.getProperty(PERFORMANCE_TRACE_FILE, DEFAULT_PERFORMANCE_TRACE_FILE_PATH);
            TraceRecordPublisher.getInstance().setPerformanceTraceFilePath(this._performanceTraceFileName);
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTraceSettings() throws IOException {
        File file = new File(TraceConfiguration.getSettingsFileName());
        Properties properties = new Properties();
        FileOutputStream stream = null;
        properties.setProperty(TRACE_ENABLED, this._isTraceEnabled ? "ON" : "OFF");
        properties.setProperty(TRACE_FILE, this._traceFileName);
        for (TraceLevel traceLevel : TraceLevel.values()) {
            properties.setProperty(traceLevel._propertyName, this._traceLevels.contains((Object)traceLevel) ? "1" : "0");
        }
        properties.setProperty(SHOW_PLAINTEXTCSE, this._isShowPlainTextCSEEnabled ? "ON" : "OFF");
        properties.setProperty(SHOW_TIMESTAMPS, this._isShowTimestampsEnabled ? "ON" : "OFF");
        properties.setProperty(TRACE_SIZE, String.valueOf(this._traceSize));
        properties.setProperty(STOP_ON_ERROR, String.valueOf(this._stopOnError));
        properties.setProperty(PERFORMANCE_TRACE_ENABLED, this._isPerformanceTraceEnabled ? "ON" : "OFF");
        properties.setProperty(PERFORMANCE_TRACE_FILE, this._performanceTraceFileName);
        boolean ignored = file.getParentFile().mkdirs();
        try {
            stream = new FileOutputStream(file);
            properties.store(stream, "HANA JDBC Trace Settings");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void printTraceSettings() {
        System.out.println("  Driver version                               : " + Driver.getVersionInfo().toShortVersionNumberString() + "\n  Settings file name                           : " + TraceConfiguration.getSettingsFileName() + "\n  Shared memory file name                      : " + TraceConfiguration.getSharedMemoryFileName() + "\n\n  Configuration\n  Trace                                        : " + (this._isTraceEnabled ? "Enabled" : "Disabled") + "\n  Trace file name                              : " + this._traceFileName + "\n  TRACE CONNECTIONS                            : " + (this._traceLevels.contains((Object)TraceLevel.CONNECTIONS) ? "On" : "Off") + "\n  TRACE API                                    : " + (this._traceLevels.contains((Object)TraceLevel.API) ? "On" : "Off") + "\n  TRACE PACKET                                 : " + (this._traceLevels.contains((Object)TraceLevel.PACKET) ? "On" : "Off") + "\n  TRACE DISTRIBUTION                           : " + (this._traceLevels.contains((Object)TraceLevel.DISTRIBUTION) ? "On" : "Off") + "\n  TRACE STATISTICS                             : " + (this._traceLevels.contains((Object)TraceLevel.STATISTICS) ? "On" : "Off") + "\n  TRACE CLEANERS                               : " + (this._traceLevels.contains((Object)TraceLevel.CLEANERS) ? "On" : "Off") + "\n  TRACE DEBUG                                  : " + (this._traceLevels.contains((Object)TraceLevel.DEBUG) ? "On" : "Off") + "\n  Show plain-text client-side encrypted values : " + (this._isShowPlainTextCSEEnabled ? "Enabled" : "Disabled") + "\n  Show timestamps                              : " + (this._isShowTimestampsEnabled ? "Enabled" : "Disabled") + "\n  Trace file size                              : " + this.getDisplayTraceSize() + " " + this.getDisplayTraceSizeUnits() + "\n  Stop on error                                : " + (this._stopOnError == 0 ? "Disabled" : String.valueOf(this.getStopOnError())) + "\n  Performance trace                            : " + (this._isPerformanceTraceEnabled ? "Enabled" : "Disabled") + "\n  Performance trace file name                  : " + this._performanceTraceFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _attach() {
        this._shmem = null;
        this._isShmemAttached = false;
        this._isShmemAttachFailed = false;
        String sapvm = System.getProperty("SAPVM", "");
        String vmcontainer = System.getProperty("sun.misc.product", "");
        if (sapvm.equalsIgnoreCase("TRUE") && vmcontainer.equalsIgnoreCase("VMContainer")) {
            return;
        }
        File file = new File(TraceConfiguration.getSharedMemoryFileName());
        boolean doesFileExist = file.isFile();
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            fileChannel = randomAccessFile.getChannel();
            this._shmem = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 4096L);
            this._traceSwitchCount = this._shmem.getLong(0);
            if (!doesFileExist) {
                this._shmem.putLong(0, this._traceSwitchCount);
                this._shmem.force();
            }
            this._isShmemAttached = true;
        }
        catch (IOException e) {
            this._handleAttachException(e);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {}
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void _handleAttachException(Exception e) {
        this._shmem = null;
        this._isShmemAttached = false;
        this._isShmemAttachFailed = true;
    }

    private void _parseTraceOptions(String traceOptions) {
        for (String option : traceOptions.split(",")) {
            TraceLevel traceLevel = TraceLevel.decode(option);
            if (traceLevel == null) continue;
            this._traceLevels.add(traceLevel);
        }
    }

    static {
        StringBuilder builder = new StringBuilder(128);
        String syncFile = System.getProperty("com.sap.dbtech.jdbc.syncfile", null);
        if (syncFile != null && !syncFile.isEmpty()) {
            builder.append(syncFile);
        } else {
            builder.append(System.getProperty("user.home"));
            builder.append(File.separatorChar);
            builder.append(".sdb");
        }
        builder.append(File.separatorChar);
        CONFIG_DIRECTORY_NAME = builder.toString();
        File file = new File(CONFIG_DIRECTORY_NAME);
        boolean bl = file.mkdirs();
    }

    public static enum SizeUnits {
        BYTES("bytes", 1L),
        KILOBYTES("KB", 1024L),
        MEGABYTES("MB", 0x100000L),
        GIGABYTES("GB", 0x40000000L);

        private static final SizeUnits[] VALUES;
        private static final Map<String, SizeUnits> VALUES_MAP;
        private static final String[] DISPLAY_STRINGS;
        private final String _displayString;
        private final long _multiplier;

        static String[] getDisplayStrings() {
            return DISPLAY_STRINGS;
        }

        static String getDisplaySize(long size) {
            if (size == Long.MAX_VALUE) {
                return "Unlimited";
            }
            long displaySize = size;
            if (displaySize != 0L) {
                for (int i = VALUES.length - 1; i >= 0; --i) {
                    SizeUnits sizeUnits = VALUES[i];
                    if (displaySize % sizeUnits._multiplier != 0L) continue;
                    return String.valueOf(displaySize /= sizeUnits._multiplier);
                }
            }
            return String.valueOf(displaySize);
        }

        static String getDisplayUnits(long size) {
            if (size == Long.MAX_VALUE) {
                return "";
            }
            if (size != 0L) {
                for (int i = VALUES.length - 1; i >= 0; --i) {
                    SizeUnits sizeUnits = VALUES[i];
                    if (size % sizeUnits._multiplier != 0L) continue;
                    return sizeUnits._displayString;
                }
            }
            return SizeUnits.BYTES._displayString;
        }

        static long getSizeWithoutUnits(long size, String units) {
            SizeUnits sizeUnits = VALUES_MAP.get(units);
            if (sizeUnits == null) {
                sizeUnits = BYTES;
            }
            long sizeWithoutUnits = size * sizeUnits._multiplier;
            return sizeWithoutUnits;
        }

        private SizeUnits(String displayString, long multiplier) {
            this._displayString = displayString;
            this._multiplier = multiplier;
        }

        public String getDisplayString() {
            return this._displayString;
        }

        static {
            VALUES = SizeUnits.values();
            LinkedHashMap<String, SizeUnits> valuesMap = new LinkedHashMap<String, SizeUnits>();
            for (SizeUnits value : VALUES) {
                valuesMap.put(value._displayString, value);
            }
            VALUES_MAP = Collections.unmodifiableMap(valuesMap);
            DISPLAY_STRINGS = valuesMap.keySet().toArray(new String[0]);
        }
    }

    public static enum TraceLevel {
        API,
        PACKET,
        DISTRIBUTION,
        STATISTICS,
        CONNECTIONS,
        DEBUG,
        CLEANERS;

        private final String _propertyName = "TRACE " + this.name();

        private static TraceLevel decode(String name) {
            TraceLevel traceLevel;
            try {
                traceLevel = TraceLevel.valueOf(name.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                traceLevel = null;
            }
            return traceLevel;
        }
    }
}

