/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext.wrapper;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbcext.wrapper.Connection;
import com.sap.db.jdbcext.wrapper.WrappedResultSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

@ThreadSafe
public abstract class Statement
implements java.sql.Statement {
    protected final java.sql.Statement _inner;
    protected final Object _creator;
    protected final Connection _clientConnection;
    @GuardedBy(value="this")
    protected ResultSet _wrappedResultSet;

    protected Statement(java.sql.Statement inner, Object creator, Connection clientConnection) {
        this._inner = inner;
        this._creator = creator;
        this._clientConnection = clientConnection;
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            ResultSet resultSet = this._inner.executeQuery(sql);
            if (resultSet != null) {
                this._wrappedResultSet = WrappedResultSet.newInstance(resultSet, this, this._clientConnection);
            }
            return this._wrappedResultSet;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this._inner.close();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this._inner.getMaxFieldSize();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int maxFieldSize) throws SQLException {
        try {
            this._inner.setMaxFieldSize(maxFieldSize);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this._inner.getMaxRows();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setMaxRows(int maxRows) throws SQLException {
        try {
            this._inner.setMaxRows(maxRows);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this._inner.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this._inner.getQueryTimeout();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this._inner.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this._inner.cancel();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this._inner.getWarnings();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this._inner.clearWarnings();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String cursorName) throws SQLException {
        try {
            this._inner.setCursorName(cursorName);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        try {
            ResultSet resultSet;
            if (this._wrappedResultSet == null && (resultSet = this._inner.getResultSet()) != null) {
                this._wrappedResultSet = WrappedResultSet.newInstance(resultSet, this, this._clientConnection);
            }
            return this._wrappedResultSet;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this._inner.getUpdateCount();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.getMoreResults();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this._inner.getFetchDirection();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int fetchDirection) throws SQLException {
        try {
            this._inner.setFetchDirection(fetchDirection);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this._inner.getFetchSize();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        try {
            this._inner.setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this._inner.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this._inner.getResultSetType();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this._inner.addBatch(sql);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this._inner.clearBatch();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeBatch();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        return (java.sql.Connection)this._creator;
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.getMoreResults(current);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            ResultSet result = this._inner.getGeneratedKeys();
            if (result != null) {
                result = WrappedResultSet.newInstance(result, this, this._clientConnection);
            }
            return result;
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this._inner.getResultSetHoldability();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this._inner.isClosed();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this._inner.isPoolable();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setPoolable(boolean isPoolable) throws SQLException {
        try {
            this._inner.setPoolable(isPoolable);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            return this._inner.isCloseOnCompletion();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this._inner.closeOnCompletion();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            return this._inner.getLargeUpdateCount();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            return this._inner.getLargeMaxRows();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        try {
            this._inner.setLargeMaxRows(max);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeBatch();
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            this._wrappedResultSet = null;
            return this._inner.executeLargeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            return this._inner.unwrap(iface);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            return this._inner.isWrapperFor(iface);
        }
        catch (SQLException e) {
            this._clientConnection.sendConnectionErrorEvent(e);
            throw e;
        }
    }

    public java.sql.Statement getInner() {
        return this._inner;
    }
}

