/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum SessionReattachOption {
    ReattachType(1),
    ReattachToken(2),
    SessionID(3),
    ServerReattachStatus(4),
    ClientReattachStatus(5),
    ReattachFailureReason(6),
    Unknown(-1);

    private static final SessionReattachOption[] VALUES;

    public static SessionReattachOption decode(int value) {
        return value >= 1 && value < VALUES.length ? VALUES[value - 1] : Unknown;
    }

    public static String getDisplayName(int value) {
        return SessionReattachOption.decode(value).name() + '(' + value + ')';
    }

    private SessionReattachOption(int value) {
        if (value != this.ordinal() + 1 && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    static {
        VALUES = SessionReattachOption.values();
    }
}

